/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.keyvault.models.Permissions;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;

public final class AccessPolicyEntry {
    @JsonProperty(value="tenantId", required=true)
    private UUID tenantId;
    @JsonProperty(value="objectId", required=true)
    private String objectId;
    @JsonProperty(value="applicationId")
    private UUID applicationId;
    @JsonProperty(value="permissions", required=true)
    private Permissions permissions;
    private static final ClientLogger LOGGER = new ClientLogger(AccessPolicyEntry.class);

    public UUID tenantId() {
        return this.tenantId;
    }

    public AccessPolicyEntry withTenantId(UUID tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String objectId() {
        return this.objectId;
    }

    public AccessPolicyEntry withObjectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    public UUID applicationId() {
        return this.applicationId;
    }

    public AccessPolicyEntry withApplicationId(UUID applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public Permissions permissions() {
        return this.permissions;
    }

    public AccessPolicyEntry withPermissions(Permissions permissions) {
        this.permissions = permissions;
        return this;
    }

    public void validate() {
        if (this.tenantId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property tenantId in model AccessPolicyEntry"));
        }
        if (this.objectId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property objectId in model AccessPolicyEntry"));
        }
        if (this.permissions() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property permissions in model AccessPolicyEntry"));
        }
        this.permissions().validate();
    }
}

