/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.models.ProvisioningState;
import java.io.IOException;

public final class ClusterProperties
implements JsonSerializable<ClusterProperties> {
    private String createdAt;
    private ProvisioningState provisioningState;
    private String updatedAt;
    private String metricId;
    private String status;
    private Boolean supportsScaling;

    public String createdAt() {
        return this.createdAt;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String updatedAt() {
        return this.updatedAt;
    }

    public String metricId() {
        return this.metricId;
    }

    public String status() {
        return this.status;
    }

    public Boolean supportsScaling() {
        return this.supportsScaling;
    }

    public ClusterProperties withSupportsScaling(Boolean supportsScaling) {
        this.supportsScaling = supportsScaling;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("supportsScaling", this.supportsScaling);
        return jsonWriter.writeEndObject();
    }

    public static ClusterProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterProperties)jsonReader.readObject(reader -> {
            ClusterProperties deserializedClusterProperties = new ClusterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createdAt".equals(fieldName)) {
                    deserializedClusterProperties.createdAt = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedClusterProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("updatedAt".equals(fieldName)) {
                    deserializedClusterProperties.updatedAt = reader.getString();
                    continue;
                }
                if ("metricId".equals(fieldName)) {
                    deserializedClusterProperties.metricId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedClusterProperties.status = reader.getString();
                    continue;
                }
                if ("supportsScaling".equals(fieldName)) {
                    deserializedClusterProperties.supportsScaling = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterProperties;
        });
    }
}

