/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dns.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dns.fluent.models.DnsResourceReferenceRequestProperties;
import java.io.IOException;
import java.util.List;

public final class DnsResourceReferenceRequest
implements JsonSerializable<DnsResourceReferenceRequest> {
    private DnsResourceReferenceRequestProperties innerProperties;

    private DnsResourceReferenceRequestProperties innerProperties() {
        return this.innerProperties;
    }

    public List<SubResource> targetResources() {
        return this.innerProperties() == null ? null : this.innerProperties().targetResources();
    }

    public DnsResourceReferenceRequest withTargetResources(List<SubResource> targetResources) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DnsResourceReferenceRequestProperties();
        }
        this.innerProperties().withTargetResources(targetResources);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DnsResourceReferenceRequest fromJson(JsonReader jsonReader) throws IOException {
        return (DnsResourceReferenceRequest)jsonReader.readObject(reader -> {
            DnsResourceReferenceRequest deserializedDnsResourceReferenceRequest = new DnsResourceReferenceRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedDnsResourceReferenceRequest.innerProperties = DnsResourceReferenceRequestProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDnsResourceReferenceRequest;
        });
    }
}

