/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dns.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dns.models.ZoneType;
import java.io.IOException;
import java.util.List;

public final class ZoneProperties
implements JsonSerializable<ZoneProperties> {
    private Long maxNumberOfRecordSets;
    private Long maxNumberOfRecordsPerRecordSet;
    private Long numberOfRecordSets;
    private List<String> nameServers;
    private ZoneType zoneType;
    private List<SubResource> registrationVirtualNetworks;
    private List<SubResource> resolutionVirtualNetworks;

    public Long maxNumberOfRecordSets() {
        return this.maxNumberOfRecordSets;
    }

    public Long maxNumberOfRecordsPerRecordSet() {
        return this.maxNumberOfRecordsPerRecordSet;
    }

    public Long numberOfRecordSets() {
        return this.numberOfRecordSets;
    }

    public List<String> nameServers() {
        return this.nameServers;
    }

    public ZoneType zoneType() {
        return this.zoneType;
    }

    public ZoneProperties withZoneType(ZoneType zoneType) {
        this.zoneType = zoneType;
        return this;
    }

    public List<SubResource> registrationVirtualNetworks() {
        return this.registrationVirtualNetworks;
    }

    public ZoneProperties withRegistrationVirtualNetworks(List<SubResource> registrationVirtualNetworks) {
        this.registrationVirtualNetworks = registrationVirtualNetworks;
        return this;
    }

    public List<SubResource> resolutionVirtualNetworks() {
        return this.resolutionVirtualNetworks;
    }

    public ZoneProperties withResolutionVirtualNetworks(List<SubResource> resolutionVirtualNetworks) {
        this.resolutionVirtualNetworks = resolutionVirtualNetworks;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("zoneType", this.zoneType == null ? null : this.zoneType.toString());
        jsonWriter.writeArrayField("registrationVirtualNetworks", this.registrationVirtualNetworks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("resolutionVirtualNetworks", this.resolutionVirtualNetworks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ZoneProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ZoneProperties)jsonReader.readObject(reader -> {
            ZoneProperties deserializedZoneProperties = new ZoneProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxNumberOfRecordSets".equals(fieldName)) {
                    deserializedZoneProperties.maxNumberOfRecordSets = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("maxNumberOfRecordsPerRecordSet".equals(fieldName)) {
                    deserializedZoneProperties.maxNumberOfRecordsPerRecordSet = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("numberOfRecordSets".equals(fieldName)) {
                    deserializedZoneProperties.numberOfRecordSets = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("nameServers".equals(fieldName)) {
                    List nameServers;
                    deserializedZoneProperties.nameServers = nameServers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("zoneType".equals(fieldName)) {
                    deserializedZoneProperties.zoneType = ZoneType.fromString(reader.getString());
                    continue;
                }
                if ("registrationVirtualNetworks".equals(fieldName)) {
                    List registrationVirtualNetworks;
                    deserializedZoneProperties.registrationVirtualNetworks = registrationVirtualNetworks = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("resolutionVirtualNetworks".equals(fieldName)) {
                    List resolutionVirtualNetworks;
                    deserializedZoneProperties.resolutionVirtualNetworks = resolutionVirtualNetworks = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedZoneProperties;
        });
    }
}

