/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.AutoscaleSettings;
import com.azure.resourcemanager.cosmos.models.OptionsResource;
import java.io.IOException;

public final class TableGetPropertiesOptions
extends OptionsResource {
    @Override
    public TableGetPropertiesOptions withThroughput(Integer throughput) {
        super.withThroughput(throughput);
        return this;
    }

    @Override
    public TableGetPropertiesOptions withAutoscaleSettings(AutoscaleSettings autoscaleSettings) {
        super.withAutoscaleSettings(autoscaleSettings);
        return this;
    }

    @Override
    public void validate() {
        if (this.autoscaleSettings() != null) {
            this.autoscaleSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("throughput", (Number)this.throughput());
        jsonWriter.writeJsonField("autoscaleSettings", (JsonSerializable)this.autoscaleSettings());
        return jsonWriter.writeEndObject();
    }

    public static TableGetPropertiesOptions fromJson(JsonReader jsonReader) throws IOException {
        return (TableGetPropertiesOptions)jsonReader.readObject(reader -> {
            TableGetPropertiesOptions deserializedTableGetPropertiesOptions = new TableGetPropertiesOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("throughput".equals(fieldName)) {
                    deserializedTableGetPropertiesOptions.withThroughput((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("autoscaleSettings".equals(fieldName)) {
                    deserializedTableGetPropertiesOptions.withAutoscaleSettings(AutoscaleSettings.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTableGetPropertiesOptions;
        });
    }
}

