/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.BackupPolicy;
import com.azure.resourcemanager.cosmos.models.BackupPolicyMigrationState;
import com.azure.resourcemanager.cosmos.models.BackupPolicyType;
import com.azure.resourcemanager.cosmos.models.ContinuousModeProperties;
import java.io.IOException;

public final class ContinuousModeBackupPolicy
extends BackupPolicy {
    private BackupPolicyType type = BackupPolicyType.CONTINUOUS;
    private ContinuousModeProperties continuousModeProperties;

    @Override
    public BackupPolicyType type() {
        return this.type;
    }

    public ContinuousModeProperties continuousModeProperties() {
        return this.continuousModeProperties;
    }

    public ContinuousModeBackupPolicy withContinuousModeProperties(ContinuousModeProperties continuousModeProperties) {
        this.continuousModeProperties = continuousModeProperties;
        return this;
    }

    @Override
    public ContinuousModeBackupPolicy withMigrationState(BackupPolicyMigrationState migrationState) {
        super.withMigrationState(migrationState);
        return this;
    }

    @Override
    public void validate() {
        if (this.continuousModeProperties() != null) {
            this.continuousModeProperties().validate();
        }
        if (this.migrationState() != null) {
            this.migrationState().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("migrationState", (JsonSerializable)this.migrationState());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("continuousModeProperties", (JsonSerializable)this.continuousModeProperties);
        return jsonWriter.writeEndObject();
    }

    public static ContinuousModeBackupPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (ContinuousModeBackupPolicy)jsonReader.readObject(reader -> {
            ContinuousModeBackupPolicy deserializedContinuousModeBackupPolicy = new ContinuousModeBackupPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("migrationState".equals(fieldName)) {
                    deserializedContinuousModeBackupPolicy.withMigrationState(BackupPolicyMigrationState.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedContinuousModeBackupPolicy.type = BackupPolicyType.fromString(reader.getString());
                    continue;
                }
                if ("continuousModeProperties".equals(fieldName)) {
                    deserializedContinuousModeBackupPolicy.continuousModeProperties = ContinuousModeProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContinuousModeBackupPolicy;
        });
    }
}

