/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.ClientEncryptionIncludedPath;
import java.io.IOException;
import java.util.List;

public final class ClientEncryptionPolicy
implements JsonSerializable<ClientEncryptionPolicy> {
    private List<ClientEncryptionIncludedPath> includedPaths;
    private int policyFormatVersion;
    private static final ClientLogger LOGGER = new ClientLogger(ClientEncryptionPolicy.class);

    public List<ClientEncryptionIncludedPath> includedPaths() {
        return this.includedPaths;
    }

    public ClientEncryptionPolicy withIncludedPaths(List<ClientEncryptionIncludedPath> includedPaths) {
        this.includedPaths = includedPaths;
        return this;
    }

    public int policyFormatVersion() {
        return this.policyFormatVersion;
    }

    public ClientEncryptionPolicy withPolicyFormatVersion(int policyFormatVersion) {
        this.policyFormatVersion = policyFormatVersion;
        return this;
    }

    public void validate() {
        if (this.includedPaths() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property includedPaths in model ClientEncryptionPolicy"));
        }
        this.includedPaths().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("includedPaths", this.includedPaths, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeIntField("policyFormatVersion", this.policyFormatVersion);
        return jsonWriter.writeEndObject();
    }

    public static ClientEncryptionPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (ClientEncryptionPolicy)jsonReader.readObject(reader -> {
            ClientEncryptionPolicy deserializedClientEncryptionPolicy = new ClientEncryptionPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("includedPaths".equals(fieldName)) {
                    List includedPaths;
                    deserializedClientEncryptionPolicy.includedPaths = includedPaths = reader.readArray(reader1 -> ClientEncryptionIncludedPath.fromJson(reader1));
                    continue;
                }
                if ("policyFormatVersion".equals(fieldName)) {
                    deserializedClientEncryptionPolicy.policyFormatVersion = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClientEncryptionPolicy;
        });
    }
}

