/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.cosmos.models.AnalyticalStorageConfiguration;
import com.azure.resourcemanager.cosmos.models.ApiProperties;
import com.azure.resourcemanager.cosmos.models.BackupPolicy;
import com.azure.resourcemanager.cosmos.models.Capability;
import com.azure.resourcemanager.cosmos.models.Capacity;
import com.azure.resourcemanager.cosmos.models.ConnectorOffer;
import com.azure.resourcemanager.cosmos.models.ConsistencyPolicy;
import com.azure.resourcemanager.cosmos.models.CorsPolicy;
import com.azure.resourcemanager.cosmos.models.CreateMode;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountKeysMetadata;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountOfferType;
import com.azure.resourcemanager.cosmos.models.FailoverPolicy;
import com.azure.resourcemanager.cosmos.models.IpAddressOrRange;
import com.azure.resourcemanager.cosmos.models.Location;
import com.azure.resourcemanager.cosmos.models.MinimalTlsVersion;
import com.azure.resourcemanager.cosmos.models.NetworkAclBypass;
import com.azure.resourcemanager.cosmos.models.PublicNetworkAccess;
import com.azure.resourcemanager.cosmos.models.RestoreParameters;
import com.azure.resourcemanager.cosmos.models.VirtualNetworkRule;
import java.io.IOException;
import java.util.List;

public final class DatabaseAccountGetProperties
implements JsonSerializable<DatabaseAccountGetProperties> {
    private String provisioningState;
    private String documentEndpoint;
    private DatabaseAccountOfferType databaseAccountOfferType;
    private List<IpAddressOrRange> ipRules;
    private Boolean isVirtualNetworkFilterEnabled;
    private Boolean enableAutomaticFailover;
    private ConsistencyPolicy consistencyPolicy;
    private List<Capability> capabilities;
    private List<Location> writeLocations;
    private List<Location> readLocations;
    private List<Location> locations;
    private List<FailoverPolicy> failoverPolicies;
    private List<VirtualNetworkRule> virtualNetworkRules;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private Boolean enableMultipleWriteLocations;
    private Boolean enableCassandraConnector;
    private ConnectorOffer connectorOffer;
    private Boolean disableKeyBasedMetadataWriteAccess;
    private String keyVaultKeyUri;
    private String defaultIdentity;
    private PublicNetworkAccess publicNetworkAccess;
    private Boolean enableFreeTier;
    private ApiProperties apiProperties;
    private Boolean enableAnalyticalStorage;
    private AnalyticalStorageConfiguration analyticalStorageConfiguration;
    private String instanceId;
    private CreateMode createMode;
    private RestoreParameters restoreParameters;
    private BackupPolicy backupPolicy;
    private List<CorsPolicy> cors;
    private NetworkAclBypass networkAclBypass;
    private List<String> networkAclBypassResourceIds;
    private Boolean disableLocalAuth;
    private Capacity capacity;
    private DatabaseAccountKeysMetadata keysMetadata;
    private Boolean enablePartitionMerge;
    private MinimalTlsVersion minimalTlsVersion;
    private Boolean enableBurstCapacity;
    private String customerManagedKeyStatus;
    private Boolean enablePerRegionPerPartitionAutoscale;

    public String provisioningState() {
        return this.provisioningState;
    }

    public String documentEndpoint() {
        return this.documentEndpoint;
    }

    public DatabaseAccountOfferType databaseAccountOfferType() {
        return this.databaseAccountOfferType;
    }

    public List<IpAddressOrRange> ipRules() {
        return this.ipRules;
    }

    public DatabaseAccountGetProperties withIpRules(List<IpAddressOrRange> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    public Boolean isVirtualNetworkFilterEnabled() {
        return this.isVirtualNetworkFilterEnabled;
    }

    public DatabaseAccountGetProperties withIsVirtualNetworkFilterEnabled(Boolean isVirtualNetworkFilterEnabled) {
        this.isVirtualNetworkFilterEnabled = isVirtualNetworkFilterEnabled;
        return this;
    }

    public Boolean enableAutomaticFailover() {
        return this.enableAutomaticFailover;
    }

    public DatabaseAccountGetProperties withEnableAutomaticFailover(Boolean enableAutomaticFailover) {
        this.enableAutomaticFailover = enableAutomaticFailover;
        return this;
    }

    public ConsistencyPolicy consistencyPolicy() {
        return this.consistencyPolicy;
    }

    public DatabaseAccountGetProperties withConsistencyPolicy(ConsistencyPolicy consistencyPolicy) {
        this.consistencyPolicy = consistencyPolicy;
        return this;
    }

    public List<Capability> capabilities() {
        return this.capabilities;
    }

    public DatabaseAccountGetProperties withCapabilities(List<Capability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public List<Location> writeLocations() {
        return this.writeLocations;
    }

    public List<Location> readLocations() {
        return this.readLocations;
    }

    public List<Location> locations() {
        return this.locations;
    }

    public List<FailoverPolicy> failoverPolicies() {
        return this.failoverPolicies;
    }

    public List<VirtualNetworkRule> virtualNetworkRules() {
        return this.virtualNetworkRules;
    }

    public DatabaseAccountGetProperties withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        this.virtualNetworkRules = virtualNetworkRules;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public Boolean enableMultipleWriteLocations() {
        return this.enableMultipleWriteLocations;
    }

    public DatabaseAccountGetProperties withEnableMultipleWriteLocations(Boolean enableMultipleWriteLocations) {
        this.enableMultipleWriteLocations = enableMultipleWriteLocations;
        return this;
    }

    public Boolean enableCassandraConnector() {
        return this.enableCassandraConnector;
    }

    public DatabaseAccountGetProperties withEnableCassandraConnector(Boolean enableCassandraConnector) {
        this.enableCassandraConnector = enableCassandraConnector;
        return this;
    }

    public ConnectorOffer connectorOffer() {
        return this.connectorOffer;
    }

    public DatabaseAccountGetProperties withConnectorOffer(ConnectorOffer connectorOffer) {
        this.connectorOffer = connectorOffer;
        return this;
    }

    public Boolean disableKeyBasedMetadataWriteAccess() {
        return this.disableKeyBasedMetadataWriteAccess;
    }

    public DatabaseAccountGetProperties withDisableKeyBasedMetadataWriteAccess(Boolean disableKeyBasedMetadataWriteAccess) {
        this.disableKeyBasedMetadataWriteAccess = disableKeyBasedMetadataWriteAccess;
        return this;
    }

    public String keyVaultKeyUri() {
        return this.keyVaultKeyUri;
    }

    public DatabaseAccountGetProperties withKeyVaultKeyUri(String keyVaultKeyUri) {
        this.keyVaultKeyUri = keyVaultKeyUri;
        return this;
    }

    public String defaultIdentity() {
        return this.defaultIdentity;
    }

    public DatabaseAccountGetProperties withDefaultIdentity(String defaultIdentity) {
        this.defaultIdentity = defaultIdentity;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public DatabaseAccountGetProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public Boolean enableFreeTier() {
        return this.enableFreeTier;
    }

    public DatabaseAccountGetProperties withEnableFreeTier(Boolean enableFreeTier) {
        this.enableFreeTier = enableFreeTier;
        return this;
    }

    public ApiProperties apiProperties() {
        return this.apiProperties;
    }

    public DatabaseAccountGetProperties withApiProperties(ApiProperties apiProperties) {
        this.apiProperties = apiProperties;
        return this;
    }

    public Boolean enableAnalyticalStorage() {
        return this.enableAnalyticalStorage;
    }

    public DatabaseAccountGetProperties withEnableAnalyticalStorage(Boolean enableAnalyticalStorage) {
        this.enableAnalyticalStorage = enableAnalyticalStorage;
        return this;
    }

    public AnalyticalStorageConfiguration analyticalStorageConfiguration() {
        return this.analyticalStorageConfiguration;
    }

    public DatabaseAccountGetProperties withAnalyticalStorageConfiguration(AnalyticalStorageConfiguration analyticalStorageConfiguration) {
        this.analyticalStorageConfiguration = analyticalStorageConfiguration;
        return this;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public DatabaseAccountGetProperties withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public RestoreParameters restoreParameters() {
        return this.restoreParameters;
    }

    public DatabaseAccountGetProperties withRestoreParameters(RestoreParameters restoreParameters) {
        this.restoreParameters = restoreParameters;
        return this;
    }

    public BackupPolicy backupPolicy() {
        return this.backupPolicy;
    }

    public DatabaseAccountGetProperties withBackupPolicy(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy;
        return this;
    }

    public List<CorsPolicy> cors() {
        return this.cors;
    }

    public DatabaseAccountGetProperties withCors(List<CorsPolicy> cors) {
        this.cors = cors;
        return this;
    }

    public NetworkAclBypass networkAclBypass() {
        return this.networkAclBypass;
    }

    public DatabaseAccountGetProperties withNetworkAclBypass(NetworkAclBypass networkAclBypass) {
        this.networkAclBypass = networkAclBypass;
        return this;
    }

    public List<String> networkAclBypassResourceIds() {
        return this.networkAclBypassResourceIds;
    }

    public DatabaseAccountGetProperties withNetworkAclBypassResourceIds(List<String> networkAclBypassResourceIds) {
        this.networkAclBypassResourceIds = networkAclBypassResourceIds;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public DatabaseAccountGetProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public Capacity capacity() {
        return this.capacity;
    }

    public DatabaseAccountGetProperties withCapacity(Capacity capacity) {
        this.capacity = capacity;
        return this;
    }

    public DatabaseAccountKeysMetadata keysMetadata() {
        return this.keysMetadata;
    }

    public Boolean enablePartitionMerge() {
        return this.enablePartitionMerge;
    }

    public DatabaseAccountGetProperties withEnablePartitionMerge(Boolean enablePartitionMerge) {
        this.enablePartitionMerge = enablePartitionMerge;
        return this;
    }

    public MinimalTlsVersion minimalTlsVersion() {
        return this.minimalTlsVersion;
    }

    public DatabaseAccountGetProperties withMinimalTlsVersion(MinimalTlsVersion minimalTlsVersion) {
        this.minimalTlsVersion = minimalTlsVersion;
        return this;
    }

    public Boolean enableBurstCapacity() {
        return this.enableBurstCapacity;
    }

    public DatabaseAccountGetProperties withEnableBurstCapacity(Boolean enableBurstCapacity) {
        this.enableBurstCapacity = enableBurstCapacity;
        return this;
    }

    public String customerManagedKeyStatus() {
        return this.customerManagedKeyStatus;
    }

    public DatabaseAccountGetProperties withCustomerManagedKeyStatus(String customerManagedKeyStatus) {
        this.customerManagedKeyStatus = customerManagedKeyStatus;
        return this;
    }

    public Boolean enablePerRegionPerPartitionAutoscale() {
        return this.enablePerRegionPerPartitionAutoscale;
    }

    public DatabaseAccountGetProperties withEnablePerRegionPerPartitionAutoscale(Boolean enablePerRegionPerPartitionAutoscale) {
        this.enablePerRegionPerPartitionAutoscale = enablePerRegionPerPartitionAutoscale;
        return this;
    }

    public void validate() {
        if (this.ipRules() != null) {
            this.ipRules().forEach(e -> e.validate());
        }
        if (this.consistencyPolicy() != null) {
            this.consistencyPolicy().validate();
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
        if (this.writeLocations() != null) {
            this.writeLocations().forEach(e -> e.validate());
        }
        if (this.readLocations() != null) {
            this.readLocations().forEach(e -> e.validate());
        }
        if (this.locations() != null) {
            this.locations().forEach(e -> e.validate());
        }
        if (this.failoverPolicies() != null) {
            this.failoverPolicies().forEach(e -> e.validate());
        }
        if (this.virtualNetworkRules() != null) {
            this.virtualNetworkRules().forEach(e -> e.validate());
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.apiProperties() != null) {
            this.apiProperties().validate();
        }
        if (this.analyticalStorageConfiguration() != null) {
            this.analyticalStorageConfiguration().validate();
        }
        if (this.restoreParameters() != null) {
            this.restoreParameters().validate();
        }
        if (this.backupPolicy() != null) {
            this.backupPolicy().validate();
        }
        if (this.cors() != null) {
            this.cors().forEach(e -> e.validate());
        }
        if (this.capacity() != null) {
            this.capacity().validate();
        }
        if (this.keysMetadata() != null) {
            this.keysMetadata().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("ipRules", this.ipRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("isVirtualNetworkFilterEnabled", this.isVirtualNetworkFilterEnabled);
        jsonWriter.writeBooleanField("enableAutomaticFailover", this.enableAutomaticFailover);
        jsonWriter.writeJsonField("consistencyPolicy", (JsonSerializable)this.consistencyPolicy);
        jsonWriter.writeArrayField("capabilities", this.capabilities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("virtualNetworkRules", this.virtualNetworkRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("enableMultipleWriteLocations", this.enableMultipleWriteLocations);
        jsonWriter.writeBooleanField("enableCassandraConnector", this.enableCassandraConnector);
        jsonWriter.writeStringField("connectorOffer", this.connectorOffer == null ? null : this.connectorOffer.toString());
        jsonWriter.writeBooleanField("disableKeyBasedMetadataWriteAccess", this.disableKeyBasedMetadataWriteAccess);
        jsonWriter.writeStringField("keyVaultKeyUri", this.keyVaultKeyUri);
        jsonWriter.writeStringField("defaultIdentity", this.defaultIdentity);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeBooleanField("enableFreeTier", this.enableFreeTier);
        jsonWriter.writeJsonField("apiProperties", (JsonSerializable)this.apiProperties);
        jsonWriter.writeBooleanField("enableAnalyticalStorage", this.enableAnalyticalStorage);
        jsonWriter.writeJsonField("analyticalStorageConfiguration", (JsonSerializable)this.analyticalStorageConfiguration);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        jsonWriter.writeJsonField("restoreParameters", (JsonSerializable)this.restoreParameters);
        jsonWriter.writeJsonField("backupPolicy", (JsonSerializable)this.backupPolicy);
        jsonWriter.writeArrayField("cors", this.cors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("networkAclBypass", this.networkAclBypass == null ? null : this.networkAclBypass.toString());
        jsonWriter.writeArrayField("networkAclBypassResourceIds", this.networkAclBypassResourceIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        jsonWriter.writeJsonField("capacity", (JsonSerializable)this.capacity);
        jsonWriter.writeBooleanField("enablePartitionMerge", this.enablePartitionMerge);
        jsonWriter.writeStringField("minimalTlsVersion", this.minimalTlsVersion == null ? null : this.minimalTlsVersion.toString());
        jsonWriter.writeBooleanField("enableBurstCapacity", this.enableBurstCapacity);
        jsonWriter.writeStringField("customerManagedKeyStatus", this.customerManagedKeyStatus);
        jsonWriter.writeBooleanField("enablePerRegionPerPartitionAutoscale", this.enablePerRegionPerPartitionAutoscale);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseAccountGetProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseAccountGetProperties)jsonReader.readObject(reader -> {
            DatabaseAccountGetProperties deserializedDatabaseAccountGetProperties = new DatabaseAccountGetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("documentEndpoint".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.documentEndpoint = reader.getString();
                    continue;
                }
                if ("databaseAccountOfferType".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.databaseAccountOfferType = DatabaseAccountOfferType.fromString(reader.getString());
                    continue;
                }
                if ("ipRules".equals(fieldName)) {
                    List ipRules;
                    deserializedDatabaseAccountGetProperties.ipRules = ipRules = reader.readArray(reader1 -> IpAddressOrRange.fromJson(reader1));
                    continue;
                }
                if ("isVirtualNetworkFilterEnabled".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.isVirtualNetworkFilterEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableAutomaticFailover".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.enableAutomaticFailover = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("consistencyPolicy".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.consistencyPolicy = ConsistencyPolicy.fromJson(reader);
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    List capabilities;
                    deserializedDatabaseAccountGetProperties.capabilities = capabilities = reader.readArray(reader1 -> Capability.fromJson(reader1));
                    continue;
                }
                if ("writeLocations".equals(fieldName)) {
                    List writeLocations;
                    deserializedDatabaseAccountGetProperties.writeLocations = writeLocations = reader.readArray(reader1 -> Location.fromJson(reader1));
                    continue;
                }
                if ("readLocations".equals(fieldName)) {
                    List readLocations;
                    deserializedDatabaseAccountGetProperties.readLocations = readLocations = reader.readArray(reader1 -> Location.fromJson(reader1));
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedDatabaseAccountGetProperties.locations = locations = reader.readArray(reader1 -> Location.fromJson(reader1));
                    continue;
                }
                if ("failoverPolicies".equals(fieldName)) {
                    List failoverPolicies;
                    deserializedDatabaseAccountGetProperties.failoverPolicies = failoverPolicies = reader.readArray(reader1 -> FailoverPolicy.fromJson(reader1));
                    continue;
                }
                if ("virtualNetworkRules".equals(fieldName)) {
                    List virtualNetworkRules;
                    deserializedDatabaseAccountGetProperties.virtualNetworkRules = virtualNetworkRules = reader.readArray(reader1 -> VirtualNetworkRule.fromJson(reader1));
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedDatabaseAccountGetProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("enableMultipleWriteLocations".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.enableMultipleWriteLocations = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableCassandraConnector".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.enableCassandraConnector = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("connectorOffer".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.connectorOffer = ConnectorOffer.fromString(reader.getString());
                    continue;
                }
                if ("disableKeyBasedMetadataWriteAccess".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.disableKeyBasedMetadataWriteAccess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("keyVaultKeyUri".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.keyVaultKeyUri = reader.getString();
                    continue;
                }
                if ("defaultIdentity".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.defaultIdentity = reader.getString();
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("enableFreeTier".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.enableFreeTier = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("apiProperties".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.apiProperties = ApiProperties.fromJson(reader);
                    continue;
                }
                if ("enableAnalyticalStorage".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.enableAnalyticalStorage = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("analyticalStorageConfiguration".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.analyticalStorageConfiguration = AnalyticalStorageConfiguration.fromJson(reader);
                    continue;
                }
                if ("instanceId".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.instanceId = reader.getString();
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.createMode = CreateMode.fromString(reader.getString());
                    continue;
                }
                if ("restoreParameters".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.restoreParameters = RestoreParameters.fromJson(reader);
                    continue;
                }
                if ("backupPolicy".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.backupPolicy = BackupPolicy.fromJson(reader);
                    continue;
                }
                if ("cors".equals(fieldName)) {
                    List cors;
                    deserializedDatabaseAccountGetProperties.cors = cors = reader.readArray(reader1 -> CorsPolicy.fromJson(reader1));
                    continue;
                }
                if ("networkAclBypass".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.networkAclBypass = NetworkAclBypass.fromString(reader.getString());
                    continue;
                }
                if ("networkAclBypassResourceIds".equals(fieldName)) {
                    List networkAclBypassResourceIds;
                    deserializedDatabaseAccountGetProperties.networkAclBypassResourceIds = networkAclBypassResourceIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("disableLocalAuth".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.disableLocalAuth = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.capacity = Capacity.fromJson(reader);
                    continue;
                }
                if ("keysMetadata".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.keysMetadata = DatabaseAccountKeysMetadata.fromJson(reader);
                    continue;
                }
                if ("enablePartitionMerge".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.enablePartitionMerge = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("minimalTlsVersion".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.minimalTlsVersion = MinimalTlsVersion.fromString(reader.getString());
                    continue;
                }
                if ("enableBurstCapacity".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.enableBurstCapacity = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("customerManagedKeyStatus".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.customerManagedKeyStatus = reader.getString();
                    continue;
                }
                if ("enablePerRegionPerPartitionAutoscale".equals(fieldName)) {
                    deserializedDatabaseAccountGetProperties.enablePerRegionPerPartitionAutoscale = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseAccountGetProperties;
        });
    }
}

