/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.WebhookInner;
import java.io.IOException;
import java.util.List;

public final class WebhookListResult
implements JsonSerializable<WebhookListResult> {
    private List<WebhookInner> value;
    private String nextLink;

    public List<WebhookInner> value() {
        return this.value;
    }

    public WebhookListResult withValue(List<WebhookInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public WebhookListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static WebhookListResult fromJson(JsonReader jsonReader) throws IOException {
        return (WebhookListResult)jsonReader.readObject(reader -> {
            WebhookListResult deserializedWebhookListResult = new WebhookListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedWebhookListResult.value = value = reader.readArray(reader1 -> WebhookInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedWebhookListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebhookListResult;
        });
    }
}

