/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.TaskRunPropertiesUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.IdentityProperties;
import com.azure.resourcemanager.containerregistry.models.RunRequest;
import java.io.IOException;
import java.util.Map;

public final class TaskRunUpdateParameters
implements JsonSerializable<TaskRunUpdateParameters> {
    private IdentityProperties identity;
    private TaskRunPropertiesUpdateParameters innerProperties;
    private String location;
    private Map<String, String> tags;

    public IdentityProperties identity() {
        return this.identity;
    }

    public TaskRunUpdateParameters withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    private TaskRunPropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    public String location() {
        return this.location;
    }

    public TaskRunUpdateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public TaskRunUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public RunRequest runRequest() {
        return this.innerProperties() == null ? null : this.innerProperties().runRequest();
    }

    public TaskRunUpdateParameters withRunRequest(RunRequest runRequest) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskRunPropertiesUpdateParameters();
        }
        this.innerProperties().withRunRequest(runRequest);
        return this;
    }

    public String forceUpdateTag() {
        return this.innerProperties() == null ? null : this.innerProperties().forceUpdateTag();
    }

    public TaskRunUpdateParameters withForceUpdateTag(String forceUpdateTag) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskRunPropertiesUpdateParameters();
        }
        this.innerProperties().withForceUpdateTag(forceUpdateTag);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static TaskRunUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (TaskRunUpdateParameters)jsonReader.readObject(reader -> {
            TaskRunUpdateParameters deserializedTaskRunUpdateParameters = new TaskRunUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("identity".equals(fieldName)) {
                    deserializedTaskRunUpdateParameters.identity = IdentityProperties.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedTaskRunUpdateParameters.innerProperties = TaskRunPropertiesUpdateParameters.fromJson(reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedTaskRunUpdateParameters.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedTaskRunUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTaskRunUpdateParameters;
        });
    }
}

