/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

public final class SyncUpdateProperties
implements JsonSerializable<SyncUpdateProperties> {
    private String schedule;
    private Duration syncWindow;
    private Duration messageTtl;

    public String schedule() {
        return this.schedule;
    }

    public SyncUpdateProperties withSchedule(String schedule) {
        this.schedule = schedule;
        return this;
    }

    public Duration syncWindow() {
        return this.syncWindow;
    }

    public SyncUpdateProperties withSyncWindow(Duration syncWindow) {
        this.syncWindow = syncWindow;
        return this;
    }

    public Duration messageTtl() {
        return this.messageTtl;
    }

    public SyncUpdateProperties withMessageTtl(Duration messageTtl) {
        this.messageTtl = messageTtl;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("schedule", this.schedule);
        jsonWriter.writeStringField("syncWindow", CoreUtils.durationToStringWithDays((Duration)this.syncWindow));
        jsonWriter.writeStringField("messageTtl", CoreUtils.durationToStringWithDays((Duration)this.messageTtl));
        return jsonWriter.writeEndObject();
    }

    public static SyncUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SyncUpdateProperties)jsonReader.readObject(reader -> {
            SyncUpdateProperties deserializedSyncUpdateProperties = new SyncUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schedule".equals(fieldName)) {
                    deserializedSyncUpdateProperties.schedule = reader.getString();
                    continue;
                }
                if ("syncWindow".equals(fieldName)) {
                    deserializedSyncUpdateProperties.syncWindow = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("messageTtl".equals(fieldName)) {
                    deserializedSyncUpdateProperties.messageTtl = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSyncUpdateProperties;
        });
    }
}

