/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetUpdateNetworkConfigurationProperties;
import com.azure.resourcemanager.compute.models.DeleteOptions;
import com.azure.resourcemanager.compute.models.NetworkInterfaceAuxiliaryMode;
import com.azure.resourcemanager.compute.models.NetworkInterfaceAuxiliarySku;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetUpdateIpConfiguration;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineScaleSetUpdateNetworkConfiguration
implements JsonSerializable<VirtualMachineScaleSetUpdateNetworkConfiguration> {
    private String name;
    private VirtualMachineScaleSetUpdateNetworkConfigurationProperties innerProperties;

    public String name() {
        return this.name;
    }

    public VirtualMachineScaleSetUpdateNetworkConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    private VirtualMachineScaleSetUpdateNetworkConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    public Boolean primary() {
        return this.innerProperties() == null ? null : this.innerProperties().primary();
    }

    public VirtualMachineScaleSetUpdateNetworkConfiguration withPrimary(Boolean primary) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateNetworkConfigurationProperties();
        }
        this.innerProperties().withPrimary(primary);
        return this;
    }

    public Boolean enableAcceleratedNetworking() {
        return this.innerProperties() == null ? null : this.innerProperties().enableAcceleratedNetworking();
    }

    public VirtualMachineScaleSetUpdateNetworkConfiguration withEnableAcceleratedNetworking(Boolean enableAcceleratedNetworking) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateNetworkConfigurationProperties();
        }
        this.innerProperties().withEnableAcceleratedNetworking(enableAcceleratedNetworking);
        return this;
    }

    public Boolean disableTcpStateTracking() {
        return this.innerProperties() == null ? null : this.innerProperties().disableTcpStateTracking();
    }

    public VirtualMachineScaleSetUpdateNetworkConfiguration withDisableTcpStateTracking(Boolean disableTcpStateTracking) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateNetworkConfigurationProperties();
        }
        this.innerProperties().withDisableTcpStateTracking(disableTcpStateTracking);
        return this;
    }

    public Boolean enableFpga() {
        return this.innerProperties() == null ? null : this.innerProperties().enableFpga();
    }

    public VirtualMachineScaleSetUpdateNetworkConfiguration withEnableFpga(Boolean enableFpga) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateNetworkConfigurationProperties();
        }
        this.innerProperties().withEnableFpga(enableFpga);
        return this;
    }

    public SubResource networkSecurityGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().networkSecurityGroup();
    }

    public VirtualMachineScaleSetUpdateNetworkConfiguration withNetworkSecurityGroup(SubResource networkSecurityGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateNetworkConfigurationProperties();
        }
        this.innerProperties().withNetworkSecurityGroup(networkSecurityGroup);
        return this;
    }

    public VirtualMachineScaleSetNetworkConfigurationDnsSettings dnsSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsSettings();
    }

    public VirtualMachineScaleSetUpdateNetworkConfiguration withDnsSettings(VirtualMachineScaleSetNetworkConfigurationDnsSettings dnsSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateNetworkConfigurationProperties();
        }
        this.innerProperties().withDnsSettings(dnsSettings);
        return this;
    }

    public List<VirtualMachineScaleSetUpdateIpConfiguration> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    public VirtualMachineScaleSetUpdateNetworkConfiguration withIpConfigurations(List<VirtualMachineScaleSetUpdateIpConfiguration> ipConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateNetworkConfigurationProperties();
        }
        this.innerProperties().withIpConfigurations(ipConfigurations);
        return this;
    }

    public Boolean enableIpForwarding() {
        return this.innerProperties() == null ? null : this.innerProperties().enableIpForwarding();
    }

    public VirtualMachineScaleSetUpdateNetworkConfiguration withEnableIpForwarding(Boolean enableIpForwarding) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateNetworkConfigurationProperties();
        }
        this.innerProperties().withEnableIpForwarding(enableIpForwarding);
        return this;
    }

    public DeleteOptions deleteOption() {
        return this.innerProperties() == null ? null : this.innerProperties().deleteOption();
    }

    public VirtualMachineScaleSetUpdateNetworkConfiguration withDeleteOption(DeleteOptions deleteOption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateNetworkConfigurationProperties();
        }
        this.innerProperties().withDeleteOption(deleteOption);
        return this;
    }

    public NetworkInterfaceAuxiliaryMode auxiliaryMode() {
        return this.innerProperties() == null ? null : this.innerProperties().auxiliaryMode();
    }

    public VirtualMachineScaleSetUpdateNetworkConfiguration withAuxiliaryMode(NetworkInterfaceAuxiliaryMode auxiliaryMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateNetworkConfigurationProperties();
        }
        this.innerProperties().withAuxiliaryMode(auxiliaryMode);
        return this;
    }

    public NetworkInterfaceAuxiliarySku auxiliarySku() {
        return this.innerProperties() == null ? null : this.innerProperties().auxiliarySku();
    }

    public VirtualMachineScaleSetUpdateNetworkConfiguration withAuxiliarySku(NetworkInterfaceAuxiliarySku auxiliarySku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateNetworkConfigurationProperties();
        }
        this.innerProperties().withAuxiliarySku(auxiliarySku);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetUpdateNetworkConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetUpdateNetworkConfiguration)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetUpdateNetworkConfiguration deserializedVirtualMachineScaleSetUpdateNetworkConfiguration = new VirtualMachineScaleSetUpdateNetworkConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateNetworkConfiguration.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateNetworkConfiguration.innerProperties = VirtualMachineScaleSetUpdateNetworkConfigurationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetUpdateNetworkConfiguration;
        });
    }
}

