/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.AdditionalReplicaSet;
import com.azure.resourcemanager.compute.models.EncryptionImages;
import com.azure.resourcemanager.compute.models.StorageAccountType;
import java.io.IOException;
import java.util.List;

public final class TargetRegion
implements JsonSerializable<TargetRegion> {
    private String name;
    private Integer regionalReplicaCount;
    private StorageAccountType storageAccountType;
    private EncryptionImages encryption;
    private Boolean excludeFromLatest;
    private List<AdditionalReplicaSet> additionalReplicaSets;
    private static final ClientLogger LOGGER = new ClientLogger(TargetRegion.class);

    public String name() {
        return this.name;
    }

    public TargetRegion withName(String name) {
        this.name = name;
        return this;
    }

    public Integer regionalReplicaCount() {
        return this.regionalReplicaCount;
    }

    public TargetRegion withRegionalReplicaCount(Integer regionalReplicaCount) {
        this.regionalReplicaCount = regionalReplicaCount;
        return this;
    }

    public StorageAccountType storageAccountType() {
        return this.storageAccountType;
    }

    public TargetRegion withStorageAccountType(StorageAccountType storageAccountType) {
        this.storageAccountType = storageAccountType;
        return this;
    }

    public EncryptionImages encryption() {
        return this.encryption;
    }

    public TargetRegion withEncryption(EncryptionImages encryption) {
        this.encryption = encryption;
        return this;
    }

    public Boolean excludeFromLatest() {
        return this.excludeFromLatest;
    }

    public TargetRegion withExcludeFromLatest(Boolean excludeFromLatest) {
        this.excludeFromLatest = excludeFromLatest;
        return this;
    }

    public List<AdditionalReplicaSet> additionalReplicaSets() {
        return this.additionalReplicaSets;
    }

    public TargetRegion withAdditionalReplicaSets(List<AdditionalReplicaSet> additionalReplicaSets) {
        this.additionalReplicaSets = additionalReplicaSets;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model TargetRegion"));
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.additionalReplicaSets() != null) {
            this.additionalReplicaSets().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeNumberField("regionalReplicaCount", (Number)this.regionalReplicaCount);
        jsonWriter.writeStringField("storageAccountType", this.storageAccountType == null ? null : this.storageAccountType.toString());
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        jsonWriter.writeBooleanField("excludeFromLatest", this.excludeFromLatest);
        jsonWriter.writeArrayField("additionalReplicaSets", this.additionalReplicaSets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TargetRegion fromJson(JsonReader jsonReader) throws IOException {
        return (TargetRegion)jsonReader.readObject(reader -> {
            TargetRegion deserializedTargetRegion = new TargetRegion();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedTargetRegion.name = reader.getString();
                    continue;
                }
                if ("regionalReplicaCount".equals(fieldName)) {
                    deserializedTargetRegion.regionalReplicaCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("storageAccountType".equals(fieldName)) {
                    deserializedTargetRegion.storageAccountType = StorageAccountType.fromString(reader.getString());
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedTargetRegion.encryption = EncryptionImages.fromJson(reader);
                    continue;
                }
                if ("excludeFromLatest".equals(fieldName)) {
                    deserializedTargetRegion.excludeFromLatest = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("additionalReplicaSets".equals(fieldName)) {
                    List additionalReplicaSets;
                    deserializedTargetRegion.additionalReplicaSets = additionalReplicaSets = reader.readArray(reader1 -> AdditionalReplicaSet.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTargetRegion;
        });
    }
}

