/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.RollingUpgradeActionType;
import com.azure.resourcemanager.compute.models.RollingUpgradeStatusCode;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class RollingUpgradeRunningStatus
implements JsonSerializable<RollingUpgradeRunningStatus> {
    private RollingUpgradeStatusCode code;
    private OffsetDateTime startTime;
    private RollingUpgradeActionType lastAction;
    private OffsetDateTime lastActionTime;

    public RollingUpgradeStatusCode code() {
        return this.code;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public RollingUpgradeActionType lastAction() {
        return this.lastAction;
    }

    public OffsetDateTime lastActionTime() {
        return this.lastActionTime;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static RollingUpgradeRunningStatus fromJson(JsonReader jsonReader) throws IOException {
        return (RollingUpgradeRunningStatus)jsonReader.readObject(reader -> {
            RollingUpgradeRunningStatus deserializedRollingUpgradeRunningStatus = new RollingUpgradeRunningStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedRollingUpgradeRunningStatus.code = RollingUpgradeStatusCode.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedRollingUpgradeRunningStatus.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastAction".equals(fieldName)) {
                    deserializedRollingUpgradeRunningStatus.lastAction = RollingUpgradeActionType.fromString(reader.getString());
                    continue;
                }
                if ("lastActionTime".equals(fieldName)) {
                    deserializedRollingUpgradeRunningStatus.lastActionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRollingUpgradeRunningStatus;
        });
    }
}

