/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DiskControllerTypes;
import com.azure.resourcemanager.compute.models.RestorePointSourceVMDataDisk;
import com.azure.resourcemanager.compute.models.RestorePointSourceVmosDisk;
import java.io.IOException;
import java.util.List;

public final class RestorePointSourceVMStorageProfile
implements JsonSerializable<RestorePointSourceVMStorageProfile> {
    private RestorePointSourceVmosDisk osDisk;
    private List<RestorePointSourceVMDataDisk> dataDisks;
    private DiskControllerTypes diskControllerType;

    public RestorePointSourceVmosDisk osDisk() {
        return this.osDisk;
    }

    public RestorePointSourceVMStorageProfile withOsDisk(RestorePointSourceVmosDisk osDisk) {
        this.osDisk = osDisk;
        return this;
    }

    public List<RestorePointSourceVMDataDisk> dataDisks() {
        return this.dataDisks;
    }

    public RestorePointSourceVMStorageProfile withDataDisks(List<RestorePointSourceVMDataDisk> dataDisks) {
        this.dataDisks = dataDisks;
        return this;
    }

    public DiskControllerTypes diskControllerType() {
        return this.diskControllerType;
    }

    public void validate() {
        if (this.osDisk() != null) {
            this.osDisk().validate();
        }
        if (this.dataDisks() != null) {
            this.dataDisks().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("osDisk", (JsonSerializable)this.osDisk);
        jsonWriter.writeArrayField("dataDisks", this.dataDisks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RestorePointSourceVMStorageProfile fromJson(JsonReader jsonReader) throws IOException {
        return (RestorePointSourceVMStorageProfile)jsonReader.readObject(reader -> {
            RestorePointSourceVMStorageProfile deserializedRestorePointSourceVMStorageProfile = new RestorePointSourceVMStorageProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("osDisk".equals(fieldName)) {
                    deserializedRestorePointSourceVMStorageProfile.osDisk = RestorePointSourceVmosDisk.fromJson(reader);
                    continue;
                }
                if ("dataDisks".equals(fieldName)) {
                    List dataDisks;
                    deserializedRestorePointSourceVMStorageProfile.dataDisks = dataDisks = reader.readArray(reader1 -> RestorePointSourceVMDataDisk.fromJson(reader1));
                    continue;
                }
                if ("diskControllerType".equals(fieldName)) {
                    deserializedRestorePointSourceVMStorageProfile.diskControllerType = DiskControllerTypes.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestorePointSourceVMStorageProfile;
        });
    }
}

