/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetParameters;
import com.azure.resourcemanager.compute.models.StorageAccountTypes;
import com.azure.resourcemanager.compute.models.VMDiskSecurityProfile;
import java.io.IOException;

public final class ManagedDiskParameters
extends SubResource {
    private StorageAccountTypes storageAccountType;
    private DiskEncryptionSetParameters diskEncryptionSet;
    private VMDiskSecurityProfile securityProfile;

    public StorageAccountTypes storageAccountType() {
        return this.storageAccountType;
    }

    public ManagedDiskParameters withStorageAccountType(StorageAccountTypes storageAccountType) {
        this.storageAccountType = storageAccountType;
        return this;
    }

    public DiskEncryptionSetParameters diskEncryptionSet() {
        return this.diskEncryptionSet;
    }

    public ManagedDiskParameters withDiskEncryptionSet(DiskEncryptionSetParameters diskEncryptionSet) {
        this.diskEncryptionSet = diskEncryptionSet;
        return this;
    }

    public VMDiskSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public ManagedDiskParameters withSecurityProfile(VMDiskSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public ManagedDiskParameters withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
        if (this.diskEncryptionSet() != null) {
            this.diskEncryptionSet().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("storageAccountType", this.storageAccountType == null ? null : this.storageAccountType.toString());
        jsonWriter.writeJsonField("diskEncryptionSet", (JsonSerializable)this.diskEncryptionSet);
        jsonWriter.writeJsonField("securityProfile", (JsonSerializable)this.securityProfile);
        return jsonWriter.writeEndObject();
    }

    public static ManagedDiskParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedDiskParameters)((Object)jsonReader.readObject(reader -> {
            ManagedDiskParameters deserializedManagedDiskParameters = new ManagedDiskParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagedDiskParameters.withId(reader.getString());
                    continue;
                }
                if ("storageAccountType".equals(fieldName)) {
                    deserializedManagedDiskParameters.storageAccountType = StorageAccountTypes.fromString(reader.getString());
                    continue;
                }
                if ("diskEncryptionSet".equals(fieldName)) {
                    deserializedManagedDiskParameters.diskEncryptionSet = DiskEncryptionSetParameters.fromJson(reader);
                    continue;
                }
                if ("securityProfile".equals(fieldName)) {
                    deserializedManagedDiskParameters.securityProfile = VMDiskSecurityProfile.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedDiskParameters;
        }));
    }
}

