/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.SourceVault;
import java.io.IOException;

public final class KeyForDiskEncryptionSet
implements JsonSerializable<KeyForDiskEncryptionSet> {
    private SourceVault sourceVault;
    private String keyUrl;
    private static final ClientLogger LOGGER = new ClientLogger(KeyForDiskEncryptionSet.class);

    public SourceVault sourceVault() {
        return this.sourceVault;
    }

    public KeyForDiskEncryptionSet withSourceVault(SourceVault sourceVault) {
        this.sourceVault = sourceVault;
        return this;
    }

    public String keyUrl() {
        return this.keyUrl;
    }

    public KeyForDiskEncryptionSet withKeyUrl(String keyUrl) {
        this.keyUrl = keyUrl;
        return this;
    }

    public void validate() {
        if (this.sourceVault() != null) {
            this.sourceVault().validate();
        }
        if (this.keyUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyUrl in model KeyForDiskEncryptionSet"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyUrl", this.keyUrl);
        jsonWriter.writeJsonField("sourceVault", (JsonSerializable)this.sourceVault);
        return jsonWriter.writeEndObject();
    }

    public static KeyForDiskEncryptionSet fromJson(JsonReader jsonReader) throws IOException {
        return (KeyForDiskEncryptionSet)jsonReader.readObject(reader -> {
            KeyForDiskEncryptionSet deserializedKeyForDiskEncryptionSet = new KeyForDiskEncryptionSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyUrl".equals(fieldName)) {
                    deserializedKeyForDiskEncryptionSet.keyUrl = reader.getString();
                    continue;
                }
                if ("sourceVault".equals(fieldName)) {
                    deserializedKeyForDiskEncryptionSet.sourceVault = SourceVault.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyForDiskEncryptionSet;
        });
    }
}

