/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CloudServiceSlotType;
import com.azure.resourcemanager.compute.models.LoadBalancerConfiguration;
import java.io.IOException;
import java.util.List;

public final class CloudServiceNetworkProfile
implements JsonSerializable<CloudServiceNetworkProfile> {
    private List<LoadBalancerConfiguration> loadBalancerConfigurations;
    private CloudServiceSlotType slotType;
    private SubResource swappableCloudService;

    public List<LoadBalancerConfiguration> loadBalancerConfigurations() {
        return this.loadBalancerConfigurations;
    }

    public CloudServiceNetworkProfile withLoadBalancerConfigurations(List<LoadBalancerConfiguration> loadBalancerConfigurations) {
        this.loadBalancerConfigurations = loadBalancerConfigurations;
        return this;
    }

    public CloudServiceSlotType slotType() {
        return this.slotType;
    }

    public CloudServiceNetworkProfile withSlotType(CloudServiceSlotType slotType) {
        this.slotType = slotType;
        return this;
    }

    public SubResource swappableCloudService() {
        return this.swappableCloudService;
    }

    public CloudServiceNetworkProfile withSwappableCloudService(SubResource swappableCloudService) {
        this.swappableCloudService = swappableCloudService;
        return this;
    }

    public void validate() {
        if (this.loadBalancerConfigurations() != null) {
            this.loadBalancerConfigurations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("loadBalancerConfigurations", this.loadBalancerConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("slotType", this.slotType == null ? null : this.slotType.toString());
        jsonWriter.writeJsonField("swappableCloudService", (JsonSerializable)this.swappableCloudService);
        return jsonWriter.writeEndObject();
    }

    public static CloudServiceNetworkProfile fromJson(JsonReader jsonReader) throws IOException {
        return (CloudServiceNetworkProfile)jsonReader.readObject(reader -> {
            CloudServiceNetworkProfile deserializedCloudServiceNetworkProfile = new CloudServiceNetworkProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("loadBalancerConfigurations".equals(fieldName)) {
                    List loadBalancerConfigurations;
                    deserializedCloudServiceNetworkProfile.loadBalancerConfigurations = loadBalancerConfigurations = reader.readArray(reader1 -> LoadBalancerConfiguration.fromJson(reader1));
                    continue;
                }
                if ("slotType".equals(fieldName)) {
                    deserializedCloudServiceNetworkProfile.slotType = CloudServiceSlotType.fromString(reader.getString());
                    continue;
                }
                if ("swappableCloudService".equals(fieldName)) {
                    deserializedCloudServiceNetworkProfile.swappableCloudService = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudServiceNetworkProfile;
        });
    }
}

