/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.AvailabilitySetInner;
import java.io.IOException;
import java.util.List;

public final class AvailabilitySetListResult
implements JsonSerializable<AvailabilitySetListResult> {
    private List<AvailabilitySetInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(AvailabilitySetListResult.class);

    public List<AvailabilitySetInner> value() {
        return this.value;
    }

    public AvailabilitySetListResult withValue(List<AvailabilitySetInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public AvailabilitySetListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model AvailabilitySetListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static AvailabilitySetListResult fromJson(JsonReader jsonReader) throws IOException {
        return (AvailabilitySetListResult)jsonReader.readObject(reader -> {
            AvailabilitySetListResult deserializedAvailabilitySetListResult = new AvailabilitySetListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedAvailabilitySetListResult.value = value = reader.readArray(reader1 -> AvailabilitySetInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedAvailabilitySetListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAvailabilitySetListResult;
        });
    }
}

