/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.AvailabilityPolicy;
import com.azure.resourcemanager.compute.models.DataAccessAuthMode;
import com.azure.resourcemanager.compute.models.DiskPurchasePlan;
import com.azure.resourcemanager.compute.models.Encryption;
import com.azure.resourcemanager.compute.models.EncryptionSettingsCollection;
import com.azure.resourcemanager.compute.models.NetworkAccessPolicy;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.PropertyUpdatesInProgress;
import com.azure.resourcemanager.compute.models.PublicNetworkAccess;
import com.azure.resourcemanager.compute.models.SupportedCapabilities;
import java.io.IOException;

public final class DiskUpdateProperties
implements JsonSerializable<DiskUpdateProperties> {
    private OperatingSystemTypes osType;
    private Integer diskSizeGB;
    private EncryptionSettingsCollection encryptionSettingsCollection;
    private Long diskIopsReadWrite;
    private Long diskMBpsReadWrite;
    private Long diskIopsReadOnly;
    private Long diskMBpsReadOnly;
    private Integer maxShares;
    private Encryption encryption;
    private NetworkAccessPolicy networkAccessPolicy;
    private String diskAccessId;
    private String tier;
    private Boolean burstingEnabled;
    private DiskPurchasePlan purchasePlan;
    private SupportedCapabilities supportedCapabilities;
    private PropertyUpdatesInProgress propertyUpdatesInProgress;
    private Boolean supportsHibernation;
    private PublicNetworkAccess publicNetworkAccess;
    private DataAccessAuthMode dataAccessAuthMode;
    private Boolean optimizedForFrequentAttach;
    private AvailabilityPolicy availabilityPolicy;

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public DiskUpdateProperties withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public DiskUpdateProperties withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public EncryptionSettingsCollection encryptionSettingsCollection() {
        return this.encryptionSettingsCollection;
    }

    public DiskUpdateProperties withEncryptionSettingsCollection(EncryptionSettingsCollection encryptionSettingsCollection) {
        this.encryptionSettingsCollection = encryptionSettingsCollection;
        return this;
    }

    public Long diskIopsReadWrite() {
        return this.diskIopsReadWrite;
    }

    public DiskUpdateProperties withDiskIopsReadWrite(Long diskIopsReadWrite) {
        this.diskIopsReadWrite = diskIopsReadWrite;
        return this;
    }

    public Long diskMBpsReadWrite() {
        return this.diskMBpsReadWrite;
    }

    public DiskUpdateProperties withDiskMBpsReadWrite(Long diskMBpsReadWrite) {
        this.diskMBpsReadWrite = diskMBpsReadWrite;
        return this;
    }

    public Long diskIopsReadOnly() {
        return this.diskIopsReadOnly;
    }

    public DiskUpdateProperties withDiskIopsReadOnly(Long diskIopsReadOnly) {
        this.diskIopsReadOnly = diskIopsReadOnly;
        return this;
    }

    public Long diskMBpsReadOnly() {
        return this.diskMBpsReadOnly;
    }

    public DiskUpdateProperties withDiskMBpsReadOnly(Long diskMBpsReadOnly) {
        this.diskMBpsReadOnly = diskMBpsReadOnly;
        return this;
    }

    public Integer maxShares() {
        return this.maxShares;
    }

    public DiskUpdateProperties withMaxShares(Integer maxShares) {
        this.maxShares = maxShares;
        return this;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public DiskUpdateProperties withEncryption(Encryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public NetworkAccessPolicy networkAccessPolicy() {
        return this.networkAccessPolicy;
    }

    public DiskUpdateProperties withNetworkAccessPolicy(NetworkAccessPolicy networkAccessPolicy) {
        this.networkAccessPolicy = networkAccessPolicy;
        return this;
    }

    public String diskAccessId() {
        return this.diskAccessId;
    }

    public DiskUpdateProperties withDiskAccessId(String diskAccessId) {
        this.diskAccessId = diskAccessId;
        return this;
    }

    public String tier() {
        return this.tier;
    }

    public DiskUpdateProperties withTier(String tier) {
        this.tier = tier;
        return this;
    }

    public Boolean burstingEnabled() {
        return this.burstingEnabled;
    }

    public DiskUpdateProperties withBurstingEnabled(Boolean burstingEnabled) {
        this.burstingEnabled = burstingEnabled;
        return this;
    }

    public DiskPurchasePlan purchasePlan() {
        return this.purchasePlan;
    }

    public DiskUpdateProperties withPurchasePlan(DiskPurchasePlan purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    public SupportedCapabilities supportedCapabilities() {
        return this.supportedCapabilities;
    }

    public DiskUpdateProperties withSupportedCapabilities(SupportedCapabilities supportedCapabilities) {
        this.supportedCapabilities = supportedCapabilities;
        return this;
    }

    public PropertyUpdatesInProgress propertyUpdatesInProgress() {
        return this.propertyUpdatesInProgress;
    }

    public Boolean supportsHibernation() {
        return this.supportsHibernation;
    }

    public DiskUpdateProperties withSupportsHibernation(Boolean supportsHibernation) {
        this.supportsHibernation = supportsHibernation;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public DiskUpdateProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public DataAccessAuthMode dataAccessAuthMode() {
        return this.dataAccessAuthMode;
    }

    public DiskUpdateProperties withDataAccessAuthMode(DataAccessAuthMode dataAccessAuthMode) {
        this.dataAccessAuthMode = dataAccessAuthMode;
        return this;
    }

    public Boolean optimizedForFrequentAttach() {
        return this.optimizedForFrequentAttach;
    }

    public DiskUpdateProperties withOptimizedForFrequentAttach(Boolean optimizedForFrequentAttach) {
        this.optimizedForFrequentAttach = optimizedForFrequentAttach;
        return this;
    }

    public AvailabilityPolicy availabilityPolicy() {
        return this.availabilityPolicy;
    }

    public DiskUpdateProperties withAvailabilityPolicy(AvailabilityPolicy availabilityPolicy) {
        this.availabilityPolicy = availabilityPolicy;
        return this;
    }

    public void validate() {
        if (this.encryptionSettingsCollection() != null) {
            this.encryptionSettingsCollection().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.purchasePlan() != null) {
            this.purchasePlan().validate();
        }
        if (this.supportedCapabilities() != null) {
            this.supportedCapabilities().validate();
        }
        if (this.propertyUpdatesInProgress() != null) {
            this.propertyUpdatesInProgress().validate();
        }
        if (this.availabilityPolicy() != null) {
            this.availabilityPolicy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeNumberField("diskSizeGB", (Number)this.diskSizeGB);
        jsonWriter.writeJsonField("encryptionSettingsCollection", (JsonSerializable)this.encryptionSettingsCollection);
        jsonWriter.writeNumberField("diskIOPSReadWrite", (Number)this.diskIopsReadWrite);
        jsonWriter.writeNumberField("diskMBpsReadWrite", (Number)this.diskMBpsReadWrite);
        jsonWriter.writeNumberField("diskIOPSReadOnly", (Number)this.diskIopsReadOnly);
        jsonWriter.writeNumberField("diskMBpsReadOnly", (Number)this.diskMBpsReadOnly);
        jsonWriter.writeNumberField("maxShares", (Number)this.maxShares);
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        jsonWriter.writeStringField("networkAccessPolicy", this.networkAccessPolicy == null ? null : this.networkAccessPolicy.toString());
        jsonWriter.writeStringField("diskAccessId", this.diskAccessId);
        jsonWriter.writeStringField("tier", this.tier);
        jsonWriter.writeBooleanField("burstingEnabled", this.burstingEnabled);
        jsonWriter.writeJsonField("purchasePlan", (JsonSerializable)this.purchasePlan);
        jsonWriter.writeJsonField("supportedCapabilities", (JsonSerializable)this.supportedCapabilities);
        jsonWriter.writeBooleanField("supportsHibernation", this.supportsHibernation);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeStringField("dataAccessAuthMode", this.dataAccessAuthMode == null ? null : this.dataAccessAuthMode.toString());
        jsonWriter.writeBooleanField("optimizedForFrequentAttach", this.optimizedForFrequentAttach);
        jsonWriter.writeJsonField("availabilityPolicy", (JsonSerializable)this.availabilityPolicy);
        return jsonWriter.writeEndObject();
    }

    public static DiskUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DiskUpdateProperties)jsonReader.readObject(reader -> {
            DiskUpdateProperties deserializedDiskUpdateProperties = new DiskUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("osType".equals(fieldName)) {
                    deserializedDiskUpdateProperties.osType = OperatingSystemTypes.fromString(reader.getString());
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedDiskUpdateProperties.diskSizeGB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("encryptionSettingsCollection".equals(fieldName)) {
                    deserializedDiskUpdateProperties.encryptionSettingsCollection = EncryptionSettingsCollection.fromJson(reader);
                    continue;
                }
                if ("diskIOPSReadWrite".equals(fieldName)) {
                    deserializedDiskUpdateProperties.diskIopsReadWrite = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("diskMBpsReadWrite".equals(fieldName)) {
                    deserializedDiskUpdateProperties.diskMBpsReadWrite = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("diskIOPSReadOnly".equals(fieldName)) {
                    deserializedDiskUpdateProperties.diskIopsReadOnly = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("diskMBpsReadOnly".equals(fieldName)) {
                    deserializedDiskUpdateProperties.diskMBpsReadOnly = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("maxShares".equals(fieldName)) {
                    deserializedDiskUpdateProperties.maxShares = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedDiskUpdateProperties.encryption = Encryption.fromJson(reader);
                    continue;
                }
                if ("networkAccessPolicy".equals(fieldName)) {
                    deserializedDiskUpdateProperties.networkAccessPolicy = NetworkAccessPolicy.fromString(reader.getString());
                    continue;
                }
                if ("diskAccessId".equals(fieldName)) {
                    deserializedDiskUpdateProperties.diskAccessId = reader.getString();
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedDiskUpdateProperties.tier = reader.getString();
                    continue;
                }
                if ("burstingEnabled".equals(fieldName)) {
                    deserializedDiskUpdateProperties.burstingEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("purchasePlan".equals(fieldName)) {
                    deserializedDiskUpdateProperties.purchasePlan = DiskPurchasePlan.fromJson(reader);
                    continue;
                }
                if ("supportedCapabilities".equals(fieldName)) {
                    deserializedDiskUpdateProperties.supportedCapabilities = SupportedCapabilities.fromJson(reader);
                    continue;
                }
                if ("propertyUpdatesInProgress".equals(fieldName)) {
                    deserializedDiskUpdateProperties.propertyUpdatesInProgress = PropertyUpdatesInProgress.fromJson(reader);
                    continue;
                }
                if ("supportsHibernation".equals(fieldName)) {
                    deserializedDiskUpdateProperties.supportsHibernation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedDiskUpdateProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("dataAccessAuthMode".equals(fieldName)) {
                    deserializedDiskUpdateProperties.dataAccessAuthMode = DataAccessAuthMode.fromString(reader.getString());
                    continue;
                }
                if ("optimizedForFrequentAttach".equals(fieldName)) {
                    deserializedDiskUpdateProperties.optimizedForFrequentAttach = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("availabilityPolicy".equals(fieldName)) {
                    deserializedDiskUpdateProperties.availabilityPolicy = AvailabilityPolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiskUpdateProperties;
        });
    }
}

