/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.RunCommandInputParameter;
import com.azure.resourcemanager.compute.models.UpdateResource;
import com.azure.resourcemanager.compute.models.VirtualMachineRunCommandInstanceView;
import com.azure.resourcemanager.compute.models.VirtualMachineRunCommandScriptSource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class VirtualMachineRunCommandUpdate
extends UpdateResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachineRunCommandUpdate.class);
    @JsonProperty(value="properties.source")
    private VirtualMachineRunCommandScriptSource source;
    @JsonProperty(value="properties.parameters")
    private List<RunCommandInputParameter> parameters;
    @JsonProperty(value="properties.protectedParameters")
    private List<RunCommandInputParameter> protectedParameters;
    @JsonProperty(value="properties.asyncExecution")
    private Boolean asyncExecution;
    @JsonProperty(value="properties.runAsUser")
    private String runAsUser;
    @JsonProperty(value="properties.runAsPassword")
    private String runAsPassword;
    @JsonProperty(value="properties.timeoutInSeconds")
    private Integer timeoutInSeconds;
    @JsonProperty(value="properties.outputBlobUri")
    private String outputBlobUri;
    @JsonProperty(value="properties.errorBlobUri")
    private String errorBlobUri;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private VirtualMachineRunCommandInstanceView instanceView;

    public VirtualMachineRunCommandScriptSource source() {
        return this.source;
    }

    public VirtualMachineRunCommandUpdate withSource(VirtualMachineRunCommandScriptSource source) {
        this.source = source;
        return this;
    }

    public List<RunCommandInputParameter> parameters() {
        return this.parameters;
    }

    public VirtualMachineRunCommandUpdate withParameters(List<RunCommandInputParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public List<RunCommandInputParameter> protectedParameters() {
        return this.protectedParameters;
    }

    public VirtualMachineRunCommandUpdate withProtectedParameters(List<RunCommandInputParameter> protectedParameters) {
        this.protectedParameters = protectedParameters;
        return this;
    }

    public Boolean asyncExecution() {
        return this.asyncExecution;
    }

    public VirtualMachineRunCommandUpdate withAsyncExecution(Boolean asyncExecution) {
        this.asyncExecution = asyncExecution;
        return this;
    }

    public String runAsUser() {
        return this.runAsUser;
    }

    public VirtualMachineRunCommandUpdate withRunAsUser(String runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    public String runAsPassword() {
        return this.runAsPassword;
    }

    public VirtualMachineRunCommandUpdate withRunAsPassword(String runAsPassword) {
        this.runAsPassword = runAsPassword;
        return this;
    }

    public Integer timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public VirtualMachineRunCommandUpdate withTimeoutInSeconds(Integer timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
        return this;
    }

    public String outputBlobUri() {
        return this.outputBlobUri;
    }

    public VirtualMachineRunCommandUpdate withOutputBlobUri(String outputBlobUri) {
        this.outputBlobUri = outputBlobUri;
        return this;
    }

    public String errorBlobUri() {
        return this.errorBlobUri;
    }

    public VirtualMachineRunCommandUpdate withErrorBlobUri(String errorBlobUri) {
        this.errorBlobUri = errorBlobUri;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public VirtualMachineRunCommandInstanceView instanceView() {
        return this.instanceView;
    }

    @Override
    public VirtualMachineRunCommandUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.source() != null) {
            this.source().validate();
        }
        if (this.parameters() != null) {
            this.parameters().forEach(e -> e.validate());
        }
        if (this.protectedParameters() != null) {
            this.protectedParameters().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
    }
}

