/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.Encryption;
import com.azure.resourcemanager.compute.models.EncryptionSettingsCollection;
import com.azure.resourcemanager.compute.models.NetworkAccessPolicy;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.SnapshotSku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonFlatten
public class SnapshotUpdate {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SnapshotUpdate.class);
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="sku")
    private SnapshotSku sku;
    @JsonProperty(value="properties.osType")
    private OperatingSystemTypes osType;
    @JsonProperty(value="properties.diskSizeGB")
    private Integer diskSizeGB;
    @JsonProperty(value="properties.encryptionSettingsCollection")
    private EncryptionSettingsCollection encryptionSettingsCollection;
    @JsonProperty(value="properties.encryption")
    private Encryption encryption;
    @JsonProperty(value="properties.networkAccessPolicy")
    private NetworkAccessPolicy networkAccessPolicy;
    @JsonProperty(value="properties.diskAccessId")
    private String diskAccessId;
    @JsonProperty(value="properties.supportsHibernation")
    private Boolean supportsHibernation;

    public Map<String, String> tags() {
        return this.tags;
    }

    public SnapshotUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public SnapshotSku sku() {
        return this.sku;
    }

    public SnapshotUpdate withSku(SnapshotSku sku) {
        this.sku = sku;
        return this;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public SnapshotUpdate withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public SnapshotUpdate withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public EncryptionSettingsCollection encryptionSettingsCollection() {
        return this.encryptionSettingsCollection;
    }

    public SnapshotUpdate withEncryptionSettingsCollection(EncryptionSettingsCollection encryptionSettingsCollection) {
        this.encryptionSettingsCollection = encryptionSettingsCollection;
        return this;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public SnapshotUpdate withEncryption(Encryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public NetworkAccessPolicy networkAccessPolicy() {
        return this.networkAccessPolicy;
    }

    public SnapshotUpdate withNetworkAccessPolicy(NetworkAccessPolicy networkAccessPolicy) {
        this.networkAccessPolicy = networkAccessPolicy;
        return this;
    }

    public String diskAccessId() {
        return this.diskAccessId;
    }

    public SnapshotUpdate withDiskAccessId(String diskAccessId) {
        this.diskAccessId = diskAccessId;
        return this;
    }

    public Boolean supportsHibernation() {
        return this.supportsHibernation;
    }

    public SnapshotUpdate withSupportsHibernation(Boolean supportsHibernation) {
        this.supportsHibernation = supportsHibernation;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.encryptionSettingsCollection() != null) {
            this.encryptionSettingsCollection().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
    }
}

