/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.HyperVGenerationTypes;
import com.azure.resourcemanager.compute.models.ImageStorageProfile;
import com.azure.resourcemanager.compute.models.UpdateResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonFlatten
public class ImageUpdate
extends UpdateResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ImageUpdate.class);
    @JsonProperty(value="properties.sourceVirtualMachine")
    private SubResource sourceVirtualMachine;
    @JsonProperty(value="properties.storageProfile")
    private ImageStorageProfile storageProfile;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.hyperVGeneration")
    private HyperVGenerationTypes hyperVGeneration;

    public SubResource sourceVirtualMachine() {
        return this.sourceVirtualMachine;
    }

    public ImageUpdate withSourceVirtualMachine(SubResource sourceVirtualMachine) {
        this.sourceVirtualMachine = sourceVirtualMachine;
        return this;
    }

    public ImageStorageProfile storageProfile() {
        return this.storageProfile;
    }

    public ImageUpdate withStorageProfile(ImageStorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public HyperVGenerationTypes hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public ImageUpdate withHyperVGeneration(HyperVGenerationTypes hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    @Override
    public ImageUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
    }
}

