/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.GalleryImageVersionPropertiesProvisioningState;
import com.azure.resourcemanager.compute.models.GalleryImageVersionPublishingProfile;
import com.azure.resourcemanager.compute.models.GalleryImageVersionStorageProfile;
import com.azure.resourcemanager.compute.models.ReplicationStatus;
import com.azure.resourcemanager.compute.models.UpdateResourceDefinition;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonFlatten
public class GalleryImageVersionUpdate
extends UpdateResourceDefinition {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(GalleryImageVersionUpdate.class);
    @JsonProperty(value="properties.publishingProfile")
    private GalleryImageVersionPublishingProfile publishingProfile;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private GalleryImageVersionPropertiesProvisioningState provisioningState;
    @JsonProperty(value="properties.storageProfile")
    private GalleryImageVersionStorageProfile storageProfile;
    @JsonProperty(value="properties.replicationStatus", access=JsonProperty.Access.WRITE_ONLY)
    private ReplicationStatus replicationStatus;

    public GalleryImageVersionPublishingProfile publishingProfile() {
        return this.publishingProfile;
    }

    public GalleryImageVersionUpdate withPublishingProfile(GalleryImageVersionPublishingProfile publishingProfile) {
        this.publishingProfile = publishingProfile;
        return this;
    }

    public GalleryImageVersionPropertiesProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public GalleryImageVersionStorageProfile storageProfile() {
        return this.storageProfile;
    }

    public GalleryImageVersionUpdate withStorageProfile(GalleryImageVersionStorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public ReplicationStatus replicationStatus() {
        return this.replicationStatus;
    }

    @Override
    public GalleryImageVersionUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.publishingProfile() != null) {
            this.publishingProfile().validate();
        }
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
        if (this.replicationStatus() != null) {
            this.replicationStatus().validate();
        }
    }
}

