/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetType;
import com.azure.resourcemanager.compute.models.EncryptionSetIdentity;
import com.azure.resourcemanager.compute.models.KeyForDiskEncryptionSet;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonFlatten
public class DiskEncryptionSetUpdate {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DiskEncryptionSetUpdate.class);
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="identity")
    private EncryptionSetIdentity identity;
    @JsonProperty(value="properties.encryptionType")
    private DiskEncryptionSetType encryptionType;
    @JsonProperty(value="properties.activeKey")
    private KeyForDiskEncryptionSet activeKey;
    @JsonProperty(value="properties.rotationToLatestKeyVersionEnabled")
    private Boolean rotationToLatestKeyVersionEnabled;

    public Map<String, String> tags() {
        return this.tags;
    }

    public DiskEncryptionSetUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public EncryptionSetIdentity identity() {
        return this.identity;
    }

    public DiskEncryptionSetUpdate withIdentity(EncryptionSetIdentity identity) {
        this.identity = identity;
        return this;
    }

    public DiskEncryptionSetType encryptionType() {
        return this.encryptionType;
    }

    public DiskEncryptionSetUpdate withEncryptionType(DiskEncryptionSetType encryptionType) {
        this.encryptionType = encryptionType;
        return this;
    }

    public KeyForDiskEncryptionSet activeKey() {
        return this.activeKey;
    }

    public DiskEncryptionSetUpdate withActiveKey(KeyForDiskEncryptionSet activeKey) {
        this.activeKey = activeKey;
        return this;
    }

    public Boolean rotationToLatestKeyVersionEnabled() {
        return this.rotationToLatestKeyVersionEnabled;
    }

    public DiskEncryptionSetUpdate withRotationToLatestKeyVersionEnabled(Boolean rotationToLatestKeyVersionEnabled) {
        this.rotationToLatestKeyVersionEnabled = rotationToLatestKeyVersionEnabled;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.activeKey() != null) {
            this.activeKey().validate();
        }
    }
}

