/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.DedicatedHostGroupInstanceView;
import com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import com.azure.resourcemanager.compute.models.UpdateResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class DedicatedHostGroupUpdate
extends UpdateResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DedicatedHostGroupUpdate.class);
    @JsonProperty(value="zones")
    private List<String> zones;
    @JsonProperty(value="properties.platformFaultDomainCount")
    private Integer platformFaultDomainCount;
    @JsonProperty(value="properties.hosts", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResourceReadOnly> hosts;
    @JsonProperty(value="properties.instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private DedicatedHostGroupInstanceView instanceView;
    @JsonProperty(value="properties.supportAutomaticPlacement")
    private Boolean supportAutomaticPlacement;

    public List<String> zones() {
        return this.zones;
    }

    public DedicatedHostGroupUpdate withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public Integer platformFaultDomainCount() {
        return this.platformFaultDomainCount;
    }

    public DedicatedHostGroupUpdate withPlatformFaultDomainCount(Integer platformFaultDomainCount) {
        this.platformFaultDomainCount = platformFaultDomainCount;
        return this;
    }

    public List<SubResourceReadOnly> hosts() {
        return this.hosts;
    }

    public DedicatedHostGroupInstanceView instanceView() {
        return this.instanceView;
    }

    public Boolean supportAutomaticPlacement() {
        return this.supportAutomaticPlacement;
    }

    public DedicatedHostGroupUpdate withSupportAutomaticPlacement(Boolean supportAutomaticPlacement) {
        this.supportAutomaticPlacement = supportAutomaticPlacement;
        return this;
    }

    @Override
    public DedicatedHostGroupUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.hosts() != null) {
            this.hosts().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
    }
}

