/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.GalleryApplicationVersionsClient;
import com.azure.resourcemanager.compute.fluent.models.GalleryApplicationVersionInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.GalleryApplicationVersionList;
import com.azure.resourcemanager.compute.models.GalleryApplicationVersionUpdate;
import com.azure.resourcemanager.compute.models.ReplicationStatusTypes;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class GalleryApplicationVersionsClientImpl
implements GalleryApplicationVersionsClient {
    private final ClientLogger logger = new ClientLogger(GalleryApplicationVersionsClientImpl.class);
    private final GalleryApplicationVersionsService service;
    private final ComputeManagementClientImpl client;

    GalleryApplicationVersionsClientImpl(ComputeManagementClientImpl client) {
        this.service = (GalleryApplicationVersionsService)RestProxy.create(GalleryApplicationVersionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryApplicationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null."));
        }
        if (galleryApplicationVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null."));
        }
        if (galleryApplicationVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationVersion is required and cannot be null."));
        }
        galleryApplicationVersion.validate();
        String apiVersion = "2019-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, "2019-12-01", galleryApplicationVersion, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryApplicationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null."));
        }
        if (galleryApplicationVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null."));
        }
        if (galleryApplicationVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationVersion is required and cannot be null."));
        }
        galleryApplicationVersion.validate();
        String apiVersion = "2019-12-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, "2019-12-01", galleryApplicationVersion, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<GalleryApplicationVersionInner>, GalleryApplicationVersionInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GalleryApplicationVersionInner.class), (Type)((Object)GalleryApplicationVersionInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<GalleryApplicationVersionInner>, GalleryApplicationVersionInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GalleryApplicationVersionInner.class), (Type)((Object)GalleryApplicationVersionInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<GalleryApplicationVersionInner>, GalleryApplicationVersionInner> beginCreateOrUpdate(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<GalleryApplicationVersionInner>, GalleryApplicationVersionInner> beginCreateOrUpdate(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion, context).getSyncPoller();
    }

    @Override
    public Mono<GalleryApplicationVersionInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<GalleryApplicationVersionInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public GalleryApplicationVersionInner createOrUpdate(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion) {
        return (GalleryApplicationVersionInner)((Object)this.createOrUpdateAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).block());
    }

    @Override
    public GalleryApplicationVersionInner createOrUpdate(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion, Context context) {
        return (GalleryApplicationVersionInner)((Object)this.createOrUpdateAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryApplicationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null."));
        }
        if (galleryApplicationVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null."));
        }
        if (galleryApplicationVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationVersion is required and cannot be null."));
        }
        galleryApplicationVersion.validate();
        String apiVersion = "2019-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, "2019-12-01", galleryApplicationVersion, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryApplicationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null."));
        }
        if (galleryApplicationVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null."));
        }
        if (galleryApplicationVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationVersion is required and cannot be null."));
        }
        galleryApplicationVersion.validate();
        String apiVersion = "2019-12-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, "2019-12-01", galleryApplicationVersion, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<GalleryApplicationVersionInner>, GalleryApplicationVersionInner> beginUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GalleryApplicationVersionInner.class), (Type)((Object)GalleryApplicationVersionInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<GalleryApplicationVersionInner>, GalleryApplicationVersionInner> beginUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GalleryApplicationVersionInner.class), (Type)((Object)GalleryApplicationVersionInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<GalleryApplicationVersionInner>, GalleryApplicationVersionInner> beginUpdate(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<GalleryApplicationVersionInner>, GalleryApplicationVersionInner> beginUpdate(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion, Context context) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion, context).getSyncPoller();
    }

    @Override
    public Mono<GalleryApplicationVersionInner> updateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<GalleryApplicationVersionInner> updateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion, Context context) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public GalleryApplicationVersionInner update(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion) {
        return (GalleryApplicationVersionInner)((Object)this.updateAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).block());
    }

    @Override
    public GalleryApplicationVersionInner update(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion, Context context) {
        return (GalleryApplicationVersionInner)((Object)this.updateAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion, context).block());
    }

    @Override
    public Mono<Response<GalleryApplicationVersionInner>> getWithResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, ReplicationStatusTypes expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryApplicationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null."));
        }
        if (galleryApplicationVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, expand, "2019-12-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<GalleryApplicationVersionInner>> getWithResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, ReplicationStatusTypes expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryApplicationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null."));
        }
        if (galleryApplicationVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, expand, "2019-12-01", "application/json", context);
    }

    @Override
    public Mono<GalleryApplicationVersionInner> getAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, ReplicationStatusTypes expand) {
        return this.getWithResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((GalleryApplicationVersionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<GalleryApplicationVersionInner> getAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        ReplicationStatusTypes expand = null;
        return this.getWithResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((GalleryApplicationVersionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public GalleryApplicationVersionInner get(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        ReplicationStatusTypes expand = null;
        return (GalleryApplicationVersionInner)((Object)this.getAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, expand).block());
    }

    @Override
    public Response<GalleryApplicationVersionInner> getWithResponse(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, ReplicationStatusTypes expand, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, expand, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryApplicationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null."));
        }
        if (galleryApplicationVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, "2019-12-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryApplicationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null."));
        }
        if (galleryApplicationVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, "2019-12-01", "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void delete(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        this.deleteAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName).block();
    }

    @Override
    public void delete(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, Context context) {
        this.deleteAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, context).block();
    }

    private Mono<PagedResponse<GalleryApplicationVersionInner>> listByGalleryApplicationSinglePageAsync(String resourceGroupName, String galleryName, String galleryApplicationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryApplicationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByGalleryApplication(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryApplicationName, "2019-12-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GalleryApplicationVersionList)res.getValue()).value(), ((GalleryApplicationVersionList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<GalleryApplicationVersionInner>> listByGalleryApplicationSinglePageAsync(String resourceGroupName, String galleryName, String galleryApplicationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryApplicationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByGalleryApplication(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryApplicationName, "2019-12-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GalleryApplicationVersionList)res.getValue()).value(), ((GalleryApplicationVersionList)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<GalleryApplicationVersionInner> listByGalleryApplicationAsync(String resourceGroupName, String galleryName, String galleryApplicationName) {
        return new PagedFlux(() -> this.listByGalleryApplicationSinglePageAsync(resourceGroupName, galleryName, galleryApplicationName), nextLink -> this.listByGalleryApplicationNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<GalleryApplicationVersionInner> listByGalleryApplicationAsync(String resourceGroupName, String galleryName, String galleryApplicationName, Context context) {
        return new PagedFlux(() -> this.listByGalleryApplicationSinglePageAsync(resourceGroupName, galleryName, galleryApplicationName, context), nextLink -> this.listByGalleryApplicationNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<GalleryApplicationVersionInner> listByGalleryApplication(String resourceGroupName, String galleryName, String galleryApplicationName) {
        return new PagedIterable(this.listByGalleryApplicationAsync(resourceGroupName, galleryName, galleryApplicationName));
    }

    @Override
    public PagedIterable<GalleryApplicationVersionInner> listByGalleryApplication(String resourceGroupName, String galleryName, String galleryApplicationName, Context context) {
        return new PagedIterable(this.listByGalleryApplicationAsync(resourceGroupName, galleryName, galleryApplicationName, context));
    }

    private Mono<PagedResponse<GalleryApplicationVersionInner>> listByGalleryApplicationNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByGalleryApplicationNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GalleryApplicationVersionList)res.getValue()).value(), ((GalleryApplicationVersionList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<GalleryApplicationVersionInner>> listByGalleryApplicationNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByGalleryApplicationNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GalleryApplicationVersionList)res.getValue()).value(), ((GalleryApplicationVersionList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    private static interface GalleryApplicationVersionsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="galleryName") String var4, @PathParam(value="galleryApplicationName") String var5, @PathParam(value="galleryApplicationVersionName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") GalleryApplicationVersionInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="galleryName") String var4, @PathParam(value="galleryApplicationName") String var5, @PathParam(value="galleryApplicationVersionName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") GalleryApplicationVersionUpdate var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<GalleryApplicationVersionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="galleryName") String var4, @PathParam(value="galleryApplicationName") String var5, @PathParam(value="galleryApplicationVersionName") String var6, @QueryParam(value="$expand") ReplicationStatusTypes var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="galleryName") String var4, @PathParam(value="galleryApplicationName") String var5, @PathParam(value="galleryApplicationVersionName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<GalleryApplicationVersionList>> listByGalleryApplication(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="galleryName") String var4, @PathParam(value="galleryApplicationName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<GalleryApplicationVersionList>> listByGalleryApplicationNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

