/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.CloudServicesClient;
import com.azure.resourcemanager.compute.fluent.models.CloudServiceInner;
import com.azure.resourcemanager.compute.fluent.models.CloudServiceInstanceViewInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.CloudServiceListResult;
import com.azure.resourcemanager.compute.models.CloudServiceUpdate;
import com.azure.resourcemanager.compute.models.RoleInstances;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class CloudServicesClientImpl
implements InnerSupportsGet<CloudServiceInner>,
InnerSupportsListing<CloudServiceInner>,
InnerSupportsDelete<Void>,
CloudServicesClient {
    private final ClientLogger logger = new ClientLogger(CloudServicesClientImpl.class);
    private final CloudServicesService service;
    private final ComputeManagementClientImpl client;

    CloudServicesClientImpl(ComputeManagementClientImpl client) {
        this.service = (CloudServicesService)RestProxy.create(CloudServicesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String cloudServiceName, CloudServiceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String cloudServiceName, CloudServiceInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", parameters, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<CloudServiceInner>, CloudServiceInner> beginCreateOrUpdateAsync(String resourceGroupName, String cloudServiceName, CloudServiceInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, cloudServiceName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CloudServiceInner.class), (Type)((Object)CloudServiceInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<CloudServiceInner>, CloudServiceInner> beginCreateOrUpdateAsync(String resourceGroupName, String cloudServiceName, CloudServiceInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, cloudServiceName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CloudServiceInner.class), (Type)((Object)CloudServiceInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<CloudServiceInner>, CloudServiceInner> beginCreateOrUpdate(String resourceGroupName, String cloudServiceName, CloudServiceInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, cloudServiceName, parameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<CloudServiceInner>, CloudServiceInner> beginCreateOrUpdate(String resourceGroupName, String cloudServiceName, CloudServiceInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, cloudServiceName, parameters, context).getSyncPoller();
    }

    @Override
    public Mono<CloudServiceInner> createOrUpdateAsync(String resourceGroupName, String cloudServiceName, CloudServiceInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, cloudServiceName, parameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<CloudServiceInner> createOrUpdateAsync(String resourceGroupName, String cloudServiceName) {
        CloudServiceInner parameters = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, cloudServiceName, parameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<CloudServiceInner> createOrUpdateAsync(String resourceGroupName, String cloudServiceName, CloudServiceInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, cloudServiceName, parameters, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public CloudServiceInner createOrUpdate(String resourceGroupName, String cloudServiceName, CloudServiceInner parameters) {
        return (CloudServiceInner)((Object)this.createOrUpdateAsync(resourceGroupName, cloudServiceName, parameters).block());
    }

    @Override
    public CloudServiceInner createOrUpdate(String resourceGroupName, String cloudServiceName) {
        CloudServiceInner parameters = null;
        return (CloudServiceInner)((Object)this.createOrUpdateAsync(resourceGroupName, cloudServiceName, parameters).block());
    }

    @Override
    public CloudServiceInner createOrUpdate(String resourceGroupName, String cloudServiceName, CloudServiceInner parameters, Context context) {
        return (CloudServiceInner)((Object)this.createOrUpdateAsync(resourceGroupName, cloudServiceName, parameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String cloudServiceName, Map<String, String> tags) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        CloudServiceUpdate parametersInternal = null;
        if (tags != null) {
            parametersInternal = new CloudServiceUpdate();
            parametersInternal.withTags(tags);
        }
        CloudServiceUpdate parameters = parametersInternal;
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String cloudServiceName, Map<String, String> tags, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        CloudServiceUpdate parametersInternal = null;
        if (tags != null) {
            parametersInternal = new CloudServiceUpdate();
            parametersInternal.withTags(tags);
        }
        CloudServiceUpdate parameters = parametersInternal;
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", parameters, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<CloudServiceInner>, CloudServiceInner> beginUpdateAsync(String resourceGroupName, String cloudServiceName, Map<String, String> tags) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, cloudServiceName, tags);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CloudServiceInner.class), (Type)((Object)CloudServiceInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<CloudServiceInner>, CloudServiceInner> beginUpdateAsync(String resourceGroupName, String cloudServiceName, Map<String, String> tags, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, cloudServiceName, tags, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CloudServiceInner.class), (Type)((Object)CloudServiceInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<CloudServiceInner>, CloudServiceInner> beginUpdate(String resourceGroupName, String cloudServiceName, Map<String, String> tags) {
        return this.beginUpdateAsync(resourceGroupName, cloudServiceName, tags).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<CloudServiceInner>, CloudServiceInner> beginUpdate(String resourceGroupName, String cloudServiceName, Map<String, String> tags, Context context) {
        return this.beginUpdateAsync(resourceGroupName, cloudServiceName, tags, context).getSyncPoller();
    }

    @Override
    public Mono<CloudServiceInner> updateAsync(String resourceGroupName, String cloudServiceName, Map<String, String> tags) {
        return this.beginUpdateAsync(resourceGroupName, cloudServiceName, tags).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<CloudServiceInner> updateAsync(String resourceGroupName, String cloudServiceName) {
        Map<String, String> tags = null;
        return this.beginUpdateAsync(resourceGroupName, cloudServiceName, tags).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<CloudServiceInner> updateAsync(String resourceGroupName, String cloudServiceName, Map<String, String> tags, Context context) {
        return this.beginUpdateAsync(resourceGroupName, cloudServiceName, tags, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public CloudServiceInner update(String resourceGroupName, String cloudServiceName, Map<String, String> tags) {
        return (CloudServiceInner)((Object)this.updateAsync(resourceGroupName, cloudServiceName, tags).block());
    }

    @Override
    public CloudServiceInner update(String resourceGroupName, String cloudServiceName) {
        Map<String, String> tags = null;
        return (CloudServiceInner)((Object)this.updateAsync(resourceGroupName, cloudServiceName, tags).block());
    }

    @Override
    public CloudServiceInner update(String resourceGroupName, String cloudServiceName, Map<String, String> tags, Context context) {
        return (CloudServiceInner)((Object)this.updateAsync(resourceGroupName, cloudServiceName, tags, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String cloudServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String cloudServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String cloudServiceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, cloudServiceName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String cloudServiceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, cloudServiceName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String cloudServiceName) {
        return this.beginDeleteAsync(resourceGroupName, cloudServiceName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String cloudServiceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, cloudServiceName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String cloudServiceName) {
        return this.beginDeleteAsync(resourceGroupName, cloudServiceName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String cloudServiceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, cloudServiceName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void delete(String resourceGroupName, String cloudServiceName) {
        this.deleteAsync(resourceGroupName, cloudServiceName).block();
    }

    @Override
    public void delete(String resourceGroupName, String cloudServiceName, Context context) {
        this.deleteAsync(resourceGroupName, cloudServiceName, context).block();
    }

    @Override
    public Mono<Response<CloudServiceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String cloudServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<CloudServiceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String cloudServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", "application/json", context);
    }

    @Override
    public Mono<CloudServiceInner> getByResourceGroupAsync(String resourceGroupName, String cloudServiceName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, cloudServiceName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((CloudServiceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public CloudServiceInner getByResourceGroup(String resourceGroupName, String cloudServiceName) {
        return (CloudServiceInner)((Object)this.getByResourceGroupAsync(resourceGroupName, cloudServiceName).block());
    }

    @Override
    public Response<CloudServiceInner> getByResourceGroupWithResponse(String resourceGroupName, String cloudServiceName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, cloudServiceName, context).block();
    }

    @Override
    public Mono<Response<CloudServiceInstanceViewInner>> getInstanceViewWithResponseAsync(String resourceGroupName, String cloudServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getInstanceView(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<CloudServiceInstanceViewInner>> getInstanceViewWithResponseAsync(String resourceGroupName, String cloudServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getInstanceView(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", "application/json", context);
    }

    @Override
    public Mono<CloudServiceInstanceViewInner> getInstanceViewAsync(String resourceGroupName, String cloudServiceName) {
        return this.getInstanceViewWithResponseAsync(resourceGroupName, cloudServiceName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CloudServiceInstanceViewInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public CloudServiceInstanceViewInner getInstanceView(String resourceGroupName, String cloudServiceName) {
        return (CloudServiceInstanceViewInner)this.getInstanceViewAsync(resourceGroupName, cloudServiceName).block();
    }

    @Override
    public Response<CloudServiceInstanceViewInner> getInstanceViewWithResponse(String resourceGroupName, String cloudServiceName, Context context) {
        return (Response)this.getInstanceViewWithResponseAsync(resourceGroupName, cloudServiceName, context).block();
    }

    private Mono<PagedResponse<CloudServiceInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2021-03-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudServiceListResult)res.getValue()).value(), ((CloudServiceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<CloudServiceInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2021-03-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudServiceListResult)res.getValue()).value(), ((CloudServiceListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<CloudServiceInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listAllNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<CloudServiceInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listAllNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<CloudServiceInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    public PagedIterable<CloudServiceInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    private Mono<PagedResponse<CloudServiceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), "2021-03-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudServiceListResult)res.getValue()).value(), ((CloudServiceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<CloudServiceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), "2021-03-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudServiceListResult)res.getValue()).value(), ((CloudServiceListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<CloudServiceInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<CloudServiceInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<CloudServiceInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    public PagedIterable<CloudServiceInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String cloudServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.start(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String cloudServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.start(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginStartAsync(String resourceGroupName, String cloudServiceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, cloudServiceName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginStartAsync(String resourceGroupName, String cloudServiceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, cloudServiceName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginStart(String resourceGroupName, String cloudServiceName) {
        return this.beginStartAsync(resourceGroupName, cloudServiceName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginStart(String resourceGroupName, String cloudServiceName, Context context) {
        return this.beginStartAsync(resourceGroupName, cloudServiceName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> startAsync(String resourceGroupName, String cloudServiceName) {
        return this.beginStartAsync(resourceGroupName, cloudServiceName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> startAsync(String resourceGroupName, String cloudServiceName, Context context) {
        return this.beginStartAsync(resourceGroupName, cloudServiceName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void start(String resourceGroupName, String cloudServiceName) {
        this.startAsync(resourceGroupName, cloudServiceName).block();
    }

    @Override
    public void start(String resourceGroupName, String cloudServiceName, Context context) {
        this.startAsync(resourceGroupName, cloudServiceName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> powerOffWithResponseAsync(String resourceGroupName, String cloudServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.powerOff(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> powerOffWithResponseAsync(String resourceGroupName, String cloudServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.powerOff(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginPowerOffAsync(String resourceGroupName, String cloudServiceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.powerOffWithResponseAsync(resourceGroupName, cloudServiceName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginPowerOffAsync(String resourceGroupName, String cloudServiceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.powerOffWithResponseAsync(resourceGroupName, cloudServiceName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginPowerOff(String resourceGroupName, String cloudServiceName) {
        return this.beginPowerOffAsync(resourceGroupName, cloudServiceName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginPowerOff(String resourceGroupName, String cloudServiceName, Context context) {
        return this.beginPowerOffAsync(resourceGroupName, cloudServiceName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> powerOffAsync(String resourceGroupName, String cloudServiceName) {
        return this.beginPowerOffAsync(resourceGroupName, cloudServiceName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> powerOffAsync(String resourceGroupName, String cloudServiceName, Context context) {
        return this.beginPowerOffAsync(resourceGroupName, cloudServiceName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void powerOff(String resourceGroupName, String cloudServiceName) {
        this.powerOffAsync(resourceGroupName, cloudServiceName).block();
    }

    @Override
    public void powerOff(String resourceGroupName, String cloudServiceName, Context context) {
        this.powerOffAsync(resourceGroupName, cloudServiceName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (roleInstances == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstances is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        RoleInstances parameters = new RoleInstances();
        parameters.withRoleInstances(roleInstances);
        return FluxUtil.withContext(context -> this.service.restart(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (roleInstances == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstances is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        RoleInstances parameters = new RoleInstances();
        parameters.withRoleInstances(roleInstances);
        context = this.client.mergeContext(context);
        return this.service.restart(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", parameters, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginRestartAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.restartWithResponseAsync(resourceGroupName, cloudServiceName, roleInstances);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginRestartAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.restartWithResponseAsync(resourceGroupName, cloudServiceName, roleInstances, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginRestart(String resourceGroupName, String cloudServiceName, List<String> roleInstances) {
        return this.beginRestartAsync(resourceGroupName, cloudServiceName, roleInstances).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginRestart(String resourceGroupName, String cloudServiceName, List<String> roleInstances, Context context) {
        return this.beginRestartAsync(resourceGroupName, cloudServiceName, roleInstances, context).getSyncPoller();
    }

    @Override
    public Mono<Void> restartAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances) {
        return this.beginRestartAsync(resourceGroupName, cloudServiceName, roleInstances).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> restartAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances, Context context) {
        return this.beginRestartAsync(resourceGroupName, cloudServiceName, roleInstances, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void restart(String resourceGroupName, String cloudServiceName, List<String> roleInstances) {
        this.restartAsync(resourceGroupName, cloudServiceName, roleInstances).block();
    }

    @Override
    public void restart(String resourceGroupName, String cloudServiceName, List<String> roleInstances, Context context) {
        this.restartAsync(resourceGroupName, cloudServiceName, roleInstances, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> reimageWithResponseAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (roleInstances == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstances is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        RoleInstances parameters = new RoleInstances();
        parameters.withRoleInstances(roleInstances);
        return FluxUtil.withContext(context -> this.service.reimage(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> reimageWithResponseAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (roleInstances == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstances is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        RoleInstances parameters = new RoleInstances();
        parameters.withRoleInstances(roleInstances);
        context = this.client.mergeContext(context);
        return this.service.reimage(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", parameters, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginReimageAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.reimageWithResponseAsync(resourceGroupName, cloudServiceName, roleInstances);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginReimageAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.reimageWithResponseAsync(resourceGroupName, cloudServiceName, roleInstances, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginReimage(String resourceGroupName, String cloudServiceName, List<String> roleInstances) {
        return this.beginReimageAsync(resourceGroupName, cloudServiceName, roleInstances).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginReimage(String resourceGroupName, String cloudServiceName, List<String> roleInstances, Context context) {
        return this.beginReimageAsync(resourceGroupName, cloudServiceName, roleInstances, context).getSyncPoller();
    }

    @Override
    public Mono<Void> reimageAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances) {
        return this.beginReimageAsync(resourceGroupName, cloudServiceName, roleInstances).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> reimageAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances, Context context) {
        return this.beginReimageAsync(resourceGroupName, cloudServiceName, roleInstances, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void reimage(String resourceGroupName, String cloudServiceName, List<String> roleInstances) {
        this.reimageAsync(resourceGroupName, cloudServiceName, roleInstances).block();
    }

    @Override
    public void reimage(String resourceGroupName, String cloudServiceName, List<String> roleInstances, Context context) {
        this.reimageAsync(resourceGroupName, cloudServiceName, roleInstances, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> rebuildWithResponseAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (roleInstances == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstances is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        RoleInstances parameters = new RoleInstances();
        parameters.withRoleInstances(roleInstances);
        return FluxUtil.withContext(context -> this.service.rebuild(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> rebuildWithResponseAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (roleInstances == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstances is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        RoleInstances parameters = new RoleInstances();
        parameters.withRoleInstances(roleInstances);
        context = this.client.mergeContext(context);
        return this.service.rebuild(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", parameters, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginRebuildAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.rebuildWithResponseAsync(resourceGroupName, cloudServiceName, roleInstances);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginRebuildAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.rebuildWithResponseAsync(resourceGroupName, cloudServiceName, roleInstances, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginRebuild(String resourceGroupName, String cloudServiceName, List<String> roleInstances) {
        return this.beginRebuildAsync(resourceGroupName, cloudServiceName, roleInstances).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginRebuild(String resourceGroupName, String cloudServiceName, List<String> roleInstances, Context context) {
        return this.beginRebuildAsync(resourceGroupName, cloudServiceName, roleInstances, context).getSyncPoller();
    }

    @Override
    public Mono<Void> rebuildAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances) {
        return this.beginRebuildAsync(resourceGroupName, cloudServiceName, roleInstances).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> rebuildAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances, Context context) {
        return this.beginRebuildAsync(resourceGroupName, cloudServiceName, roleInstances, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void rebuild(String resourceGroupName, String cloudServiceName, List<String> roleInstances) {
        this.rebuildAsync(resourceGroupName, cloudServiceName, roleInstances).block();
    }

    @Override
    public void rebuild(String resourceGroupName, String cloudServiceName, List<String> roleInstances, Context context) {
        this.rebuildAsync(resourceGroupName, cloudServiceName, roleInstances, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteInstancesWithResponseAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (roleInstances == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstances is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        RoleInstances parameters = new RoleInstances();
        parameters.withRoleInstances(roleInstances);
        return FluxUtil.withContext(context -> this.service.deleteInstances(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteInstancesWithResponseAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (roleInstances == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstances is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        RoleInstances parameters = new RoleInstances();
        parameters.withRoleInstances(roleInstances);
        context = this.client.mergeContext(context);
        return this.service.deleteInstances(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2021-03-01", parameters, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteInstancesAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteInstancesWithResponseAsync(resourceGroupName, cloudServiceName, roleInstances);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteInstancesAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteInstancesWithResponseAsync(resourceGroupName, cloudServiceName, roleInstances, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteInstances(String resourceGroupName, String cloudServiceName, List<String> roleInstances) {
        return this.beginDeleteInstancesAsync(resourceGroupName, cloudServiceName, roleInstances).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteInstances(String resourceGroupName, String cloudServiceName, List<String> roleInstances, Context context) {
        return this.beginDeleteInstancesAsync(resourceGroupName, cloudServiceName, roleInstances, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteInstancesAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances) {
        return this.beginDeleteInstancesAsync(resourceGroupName, cloudServiceName, roleInstances).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteInstancesAsync(String resourceGroupName, String cloudServiceName, List<String> roleInstances, Context context) {
        return this.beginDeleteInstancesAsync(resourceGroupName, cloudServiceName, roleInstances, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void deleteInstances(String resourceGroupName, String cloudServiceName, List<String> roleInstances) {
        this.deleteInstancesAsync(resourceGroupName, cloudServiceName, roleInstances).block();
    }

    @Override
    public void deleteInstances(String resourceGroupName, String cloudServiceName, List<String> roleInstances, Context context) {
        this.deleteInstancesAsync(resourceGroupName, cloudServiceName, roleInstances, context).block();
    }

    private Mono<PagedResponse<CloudServiceInner>> listAllNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAllNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudServiceListResult)res.getValue()).value(), ((CloudServiceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<CloudServiceInner>> listAllNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAllNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudServiceListResult)res.getValue()).value(), ((CloudServiceListResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<CloudServiceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudServiceListResult)res.getValue()).value(), ((CloudServiceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<CloudServiceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudServiceListResult)res.getValue()).value(), ((CloudServiceListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    private static interface CloudServicesService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cloudServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") CloudServiceInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cloudServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") CloudServiceUpdate var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cloudServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<CloudServiceInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cloudServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/instanceView")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<CloudServiceInstanceViewInner>> getInstanceView(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cloudServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/cloudServices")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<CloudServiceListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<CloudServiceListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/start")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> start(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cloudServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/poweroff")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> powerOff(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cloudServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/restart")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> restart(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cloudServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") RoleInstances var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/reimage")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> reimage(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cloudServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") RoleInstances var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/rebuild")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> rebuild(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cloudServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") RoleInstances var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/delete")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteInstances(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cloudServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") RoleInstances var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<CloudServiceListResult>> listAllNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<CloudServiceListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

