/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineInstanceViewInner;
import com.azure.resourcemanager.compute.models.AdditionalCapabilities;
import com.azure.resourcemanager.compute.models.BillingProfile;
import com.azure.resourcemanager.compute.models.DiagnosticsProfile;
import com.azure.resourcemanager.compute.models.HardwareProfile;
import com.azure.resourcemanager.compute.models.NetworkProfile;
import com.azure.resourcemanager.compute.models.OSProfile;
import com.azure.resourcemanager.compute.models.Plan;
import com.azure.resourcemanager.compute.models.SecurityProfile;
import com.azure.resourcemanager.compute.models.StorageProfile;
import com.azure.resourcemanager.compute.models.UpdateResource;
import com.azure.resourcemanager.compute.models.VirtualMachineEvictionPolicyTypes;
import com.azure.resourcemanager.compute.models.VirtualMachineIdentity;
import com.azure.resourcemanager.compute.models.VirtualMachinePriorityTypes;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class VirtualMachineUpdateInner
extends UpdateResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachineUpdateInner.class);
    @JsonProperty(value="plan")
    private Plan plan;
    @JsonProperty(value="identity")
    private VirtualMachineIdentity identity;
    @JsonProperty(value="zones")
    private List<String> zones;
    @JsonProperty(value="properties.hardwareProfile")
    private HardwareProfile hardwareProfile;
    @JsonProperty(value="properties.storageProfile")
    private StorageProfile storageProfile;
    @JsonProperty(value="properties.additionalCapabilities")
    private AdditionalCapabilities additionalCapabilities;
    @JsonProperty(value="properties.osProfile")
    private OSProfile osProfile;
    @JsonProperty(value="properties.networkProfile")
    private NetworkProfile networkProfile;
    @JsonProperty(value="properties.securityProfile")
    private SecurityProfile securityProfile;
    @JsonProperty(value="properties.diagnosticsProfile")
    private DiagnosticsProfile diagnosticsProfile;
    @JsonProperty(value="properties.availabilitySet")
    private SubResource availabilitySet;
    @JsonProperty(value="properties.virtualMachineScaleSet")
    private SubResource virtualMachineScaleSet;
    @JsonProperty(value="properties.proximityPlacementGroup")
    private SubResource proximityPlacementGroup;
    @JsonProperty(value="properties.priority")
    private VirtualMachinePriorityTypes priority;
    @JsonProperty(value="properties.evictionPolicy")
    private VirtualMachineEvictionPolicyTypes evictionPolicy;
    @JsonProperty(value="properties.billingProfile")
    private BillingProfile billingProfile;
    @JsonProperty(value="properties.host")
    private SubResource host;
    @JsonProperty(value="properties.hostGroup")
    private SubResource hostGroup;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private VirtualMachineInstanceViewInner instanceView;
    @JsonProperty(value="properties.licenseType")
    private String licenseType;
    @JsonProperty(value="properties.vmId", access=JsonProperty.Access.WRITE_ONLY)
    private String vmId;
    @JsonProperty(value="properties.extensionsTimeBudget")
    private String extensionsTimeBudget;
    @JsonProperty(value="properties.platformFaultDomain")
    private Integer platformFaultDomain;

    public Plan plan() {
        return this.plan;
    }

    public VirtualMachineUpdateInner withPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    public VirtualMachineIdentity identity() {
        return this.identity;
    }

    public VirtualMachineUpdateInner withIdentity(VirtualMachineIdentity identity) {
        this.identity = identity;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public VirtualMachineUpdateInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public HardwareProfile hardwareProfile() {
        return this.hardwareProfile;
    }

    public VirtualMachineUpdateInner withHardwareProfile(HardwareProfile hardwareProfile) {
        this.hardwareProfile = hardwareProfile;
        return this;
    }

    public StorageProfile storageProfile() {
        return this.storageProfile;
    }

    public VirtualMachineUpdateInner withStorageProfile(StorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public AdditionalCapabilities additionalCapabilities() {
        return this.additionalCapabilities;
    }

    public VirtualMachineUpdateInner withAdditionalCapabilities(AdditionalCapabilities additionalCapabilities) {
        this.additionalCapabilities = additionalCapabilities;
        return this;
    }

    public OSProfile osProfile() {
        return this.osProfile;
    }

    public VirtualMachineUpdateInner withOsProfile(OSProfile osProfile) {
        this.osProfile = osProfile;
        return this;
    }

    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public VirtualMachineUpdateInner withNetworkProfile(NetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public SecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public VirtualMachineUpdateInner withSecurityProfile(SecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public DiagnosticsProfile diagnosticsProfile() {
        return this.diagnosticsProfile;
    }

    public VirtualMachineUpdateInner withDiagnosticsProfile(DiagnosticsProfile diagnosticsProfile) {
        this.diagnosticsProfile = diagnosticsProfile;
        return this;
    }

    public SubResource availabilitySet() {
        return this.availabilitySet;
    }

    public VirtualMachineUpdateInner withAvailabilitySet(SubResource availabilitySet) {
        this.availabilitySet = availabilitySet;
        return this;
    }

    public SubResource virtualMachineScaleSet() {
        return this.virtualMachineScaleSet;
    }

    public VirtualMachineUpdateInner withVirtualMachineScaleSet(SubResource virtualMachineScaleSet) {
        this.virtualMachineScaleSet = virtualMachineScaleSet;
        return this;
    }

    public SubResource proximityPlacementGroup() {
        return this.proximityPlacementGroup;
    }

    public VirtualMachineUpdateInner withProximityPlacementGroup(SubResource proximityPlacementGroup) {
        this.proximityPlacementGroup = proximityPlacementGroup;
        return this;
    }

    public VirtualMachinePriorityTypes priority() {
        return this.priority;
    }

    public VirtualMachineUpdateInner withPriority(VirtualMachinePriorityTypes priority) {
        this.priority = priority;
        return this;
    }

    public VirtualMachineEvictionPolicyTypes evictionPolicy() {
        return this.evictionPolicy;
    }

    public VirtualMachineUpdateInner withEvictionPolicy(VirtualMachineEvictionPolicyTypes evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public BillingProfile billingProfile() {
        return this.billingProfile;
    }

    public VirtualMachineUpdateInner withBillingProfile(BillingProfile billingProfile) {
        this.billingProfile = billingProfile;
        return this;
    }

    public SubResource host() {
        return this.host;
    }

    public VirtualMachineUpdateInner withHost(SubResource host) {
        this.host = host;
        return this;
    }

    public SubResource hostGroup() {
        return this.hostGroup;
    }

    public VirtualMachineUpdateInner withHostGroup(SubResource hostGroup) {
        this.hostGroup = hostGroup;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public VirtualMachineInstanceViewInner instanceView() {
        return this.instanceView;
    }

    public String licenseType() {
        return this.licenseType;
    }

    public VirtualMachineUpdateInner withLicenseType(String licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public String vmId() {
        return this.vmId;
    }

    public String extensionsTimeBudget() {
        return this.extensionsTimeBudget;
    }

    public VirtualMachineUpdateInner withExtensionsTimeBudget(String extensionsTimeBudget) {
        this.extensionsTimeBudget = extensionsTimeBudget;
        return this;
    }

    public Integer platformFaultDomain() {
        return this.platformFaultDomain;
    }

    public VirtualMachineUpdateInner withPlatformFaultDomain(Integer platformFaultDomain) {
        this.platformFaultDomain = platformFaultDomain;
        return this;
    }

    @Override
    public VirtualMachineUpdateInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.plan() != null) {
            this.plan().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.hardwareProfile() != null) {
            this.hardwareProfile().validate();
        }
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
        if (this.additionalCapabilities() != null) {
            this.additionalCapabilities().validate();
        }
        if (this.osProfile() != null) {
            this.osProfile().validate();
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
        if (this.diagnosticsProfile() != null) {
            this.diagnosticsProfile().validate();
        }
        if (this.billingProfile() != null) {
            this.billingProfile().validate();
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
    }
}

