/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.MetricsResponseSeriesItemData;
import com.azure.resourcemanager.cdn.models.MetricsResponseSeriesPropertiesItemsItem;
import com.azure.resourcemanager.cdn.models.MetricsSeriesUnit;
import java.io.IOException;
import java.util.List;

public final class MetricsResponseSeriesItem
implements JsonSerializable<MetricsResponseSeriesItem> {
    private String metric;
    private MetricsSeriesUnit unit;
    private List<MetricsResponseSeriesPropertiesItemsItem> groups;
    private List<MetricsResponseSeriesItemData> data;

    public String metric() {
        return this.metric;
    }

    public MetricsResponseSeriesItem withMetric(String metric) {
        this.metric = metric;
        return this;
    }

    public MetricsSeriesUnit unit() {
        return this.unit;
    }

    public MetricsResponseSeriesItem withUnit(MetricsSeriesUnit unit) {
        this.unit = unit;
        return this;
    }

    public List<MetricsResponseSeriesPropertiesItemsItem> groups() {
        return this.groups;
    }

    public MetricsResponseSeriesItem withGroups(List<MetricsResponseSeriesPropertiesItemsItem> groups) {
        this.groups = groups;
        return this;
    }

    public List<MetricsResponseSeriesItemData> data() {
        return this.data;
    }

    public MetricsResponseSeriesItem withData(List<MetricsResponseSeriesItemData> data) {
        this.data = data;
        return this;
    }

    public void validate() {
        if (this.groups() != null) {
            this.groups().forEach(e -> e.validate());
        }
        if (this.data() != null) {
            this.data().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("metric", this.metric);
        jsonWriter.writeStringField("unit", this.unit == null ? null : this.unit.toString());
        jsonWriter.writeArrayField("groups", this.groups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MetricsResponseSeriesItem fromJson(JsonReader jsonReader) throws IOException {
        return (MetricsResponseSeriesItem)jsonReader.readObject(reader -> {
            MetricsResponseSeriesItem deserializedMetricsResponseSeriesItem = new MetricsResponseSeriesItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("metric".equals(fieldName)) {
                    deserializedMetricsResponseSeriesItem.metric = reader.getString();
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedMetricsResponseSeriesItem.unit = MetricsSeriesUnit.fromString(reader.getString());
                    continue;
                }
                if ("groups".equals(fieldName)) {
                    List groups;
                    deserializedMetricsResponseSeriesItem.groups = groups = reader.readArray(reader1 -> MetricsResponseSeriesPropertiesItemsItem.fromJson(reader1));
                    continue;
                }
                if ("data".equals(fieldName)) {
                    List data;
                    deserializedMetricsResponseSeriesItem.data = data = reader.readArray(reader1 -> MetricsResponseSeriesItemData.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricsResponseSeriesItem;
        });
    }
}

