/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.CidrIpAddress;
import java.io.IOException;
import java.util.List;

public final class IpAddressGroup
implements JsonSerializable<IpAddressGroup> {
    private String deliveryRegion;
    private List<CidrIpAddress> ipv4Addresses;
    private List<CidrIpAddress> ipv6Addresses;

    public String deliveryRegion() {
        return this.deliveryRegion;
    }

    public IpAddressGroup withDeliveryRegion(String deliveryRegion) {
        this.deliveryRegion = deliveryRegion;
        return this;
    }

    public List<CidrIpAddress> ipv4Addresses() {
        return this.ipv4Addresses;
    }

    public IpAddressGroup withIpv4Addresses(List<CidrIpAddress> ipv4Addresses) {
        this.ipv4Addresses = ipv4Addresses;
        return this;
    }

    public List<CidrIpAddress> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public IpAddressGroup withIpv6Addresses(List<CidrIpAddress> ipv6Addresses) {
        this.ipv6Addresses = ipv6Addresses;
        return this;
    }

    public void validate() {
        if (this.ipv4Addresses() != null) {
            this.ipv4Addresses().forEach(e -> e.validate());
        }
        if (this.ipv6Addresses() != null) {
            this.ipv6Addresses().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("deliveryRegion", this.deliveryRegion);
        jsonWriter.writeArrayField("ipv4Addresses", this.ipv4Addresses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("ipv6Addresses", this.ipv6Addresses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static IpAddressGroup fromJson(JsonReader jsonReader) throws IOException {
        return (IpAddressGroup)jsonReader.readObject(reader -> {
            IpAddressGroup deserializedIpAddressGroup = new IpAddressGroup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deliveryRegion".equals(fieldName)) {
                    deserializedIpAddressGroup.deliveryRegion = reader.getString();
                    continue;
                }
                if ("ipv4Addresses".equals(fieldName)) {
                    List ipv4Addresses;
                    deserializedIpAddressGroup.ipv4Addresses = ipv4Addresses = reader.readArray(reader1 -> CidrIpAddress.fromJson(reader1));
                    continue;
                }
                if ("ipv6Addresses".equals(fieldName)) {
                    List ipv6Addresses;
                    deserializedIpAddressGroup.ipv6Addresses = ipv6Addresses = reader.readArray(reader1 -> CidrIpAddress.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIpAddressGroup;
        });
    }
}

