/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.AfdCertificateType;
import com.azure.resourcemanager.cdn.models.AfdMinimumTlsVersion;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import java.io.IOException;

public final class AfdDomainHttpsParameters
implements JsonSerializable<AfdDomainHttpsParameters> {
    private AfdCertificateType certificateType;
    private AfdMinimumTlsVersion minimumTlsVersion;
    private ResourceReference secret;
    private static final ClientLogger LOGGER = new ClientLogger(AfdDomainHttpsParameters.class);

    public AfdCertificateType certificateType() {
        return this.certificateType;
    }

    public AfdDomainHttpsParameters withCertificateType(AfdCertificateType certificateType) {
        this.certificateType = certificateType;
        return this;
    }

    public AfdMinimumTlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    public AfdDomainHttpsParameters withMinimumTlsVersion(AfdMinimumTlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    public ResourceReference secret() {
        return this.secret;
    }

    public AfdDomainHttpsParameters withSecret(ResourceReference secret) {
        this.secret = secret;
        return this;
    }

    public void validate() {
        if (this.certificateType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property certificateType in model AfdDomainHttpsParameters"));
        }
        if (this.secret() != null) {
            this.secret().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("certificateType", this.certificateType == null ? null : this.certificateType.toString());
        jsonWriter.writeStringField("minimumTlsVersion", this.minimumTlsVersion == null ? null : this.minimumTlsVersion.toString());
        jsonWriter.writeJsonField("secret", (JsonSerializable)this.secret);
        return jsonWriter.writeEndObject();
    }

    public static AfdDomainHttpsParameters fromJson(JsonReader jsonReader) throws IOException {
        return (AfdDomainHttpsParameters)jsonReader.readObject(reader -> {
            AfdDomainHttpsParameters deserializedAfdDomainHttpsParameters = new AfdDomainHttpsParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("certificateType".equals(fieldName)) {
                    deserializedAfdDomainHttpsParameters.certificateType = AfdCertificateType.fromString(reader.getString());
                    continue;
                }
                if ("minimumTlsVersion".equals(fieldName)) {
                    deserializedAfdDomainHttpsParameters.minimumTlsVersion = AfdMinimumTlsVersion.fromString(reader.getString());
                    continue;
                }
                if ("secret".equals(fieldName)) {
                    deserializedAfdDomainHttpsParameters.secret = ResourceReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAfdDomainHttpsParameters;
        });
    }
}

