/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.ManagedRuleSetDefinitionProperties;
import com.azure.resourcemanager.cdn.models.ManagedRuleGroupDefinition;
import com.azure.resourcemanager.cdn.models.Sku;
import java.io.IOException;
import java.util.List;

public final class ManagedRuleSetDefinitionInner
extends ProxyResource {
    private ManagedRuleSetDefinitionProperties innerProperties;
    private Sku sku;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private ManagedRuleSetDefinitionProperties innerProperties() {
        return this.innerProperties;
    }

    public Sku sku() {
        return this.sku;
    }

    public ManagedRuleSetDefinitionInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String ruleSetType() {
        return this.innerProperties() == null ? null : this.innerProperties().ruleSetType();
    }

    public String ruleSetVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().ruleSetVersion();
    }

    public List<ManagedRuleGroupDefinition> ruleGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().ruleGroups();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        return jsonWriter.writeEndObject();
    }

    public static ManagedRuleSetDefinitionInner fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedRuleSetDefinitionInner)((Object)jsonReader.readObject(reader -> {
            ManagedRuleSetDefinitionInner deserializedManagedRuleSetDefinitionInner = new ManagedRuleSetDefinitionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagedRuleSetDefinitionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagedRuleSetDefinitionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedRuleSetDefinitionInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedManagedRuleSetDefinitionInner.innerProperties = ManagedRuleSetDefinitionProperties.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedManagedRuleSetDefinitionInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedManagedRuleSetDefinitionInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedRuleSetDefinitionInner;
        }));
    }
}

