/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphKeyCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPasswordCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphServicePrincipalInner;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsAddPasswordRequestBodyInner;
import com.azure.resourcemanager.authorization.implementation.CertificateCredentialImpl;
import com.azure.resourcemanager.authorization.implementation.HasCredential;
import com.azure.resourcemanager.authorization.implementation.PasswordCredentialImpl;
import com.azure.resourcemanager.authorization.implementation.RetryUtils;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryApplication;
import com.azure.resourcemanager.authorization.models.BuiltInRole;
import com.azure.resourcemanager.authorization.models.CertificateCredential;
import com.azure.resourcemanager.authorization.models.PasswordCredential;
import com.azure.resourcemanager.authorization.models.RoleAssignment;
import com.azure.resourcemanager.authorization.models.ServicePrincipal;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

class ServicePrincipalImpl
extends CreatableUpdatableImpl<ServicePrincipal, MicrosoftGraphServicePrincipalInner, ServicePrincipalImpl>
implements ServicePrincipal,
ServicePrincipal.Definition,
ServicePrincipal.Update,
HasCredential<ServicePrincipalImpl> {
    private AuthorizationManager manager;
    private Map<String, PasswordCredential> cachedPasswordCredentials;
    private Map<String, CertificateCredential> cachedCertificateCredentials;
    private Map<String, RoleAssignment> cachedRoleAssignments;
    private Creatable<ActiveDirectoryApplication> applicationCreatable;
    private Map<String, BuiltInRole> rolesToCreate;
    private Set<String> rolesToDelete;
    String assignedSubscription;
    private List<CertificateCredentialImpl<?>> certificateCredentialsToCreate;
    private List<PasswordCredentialImpl<?>> passwordCredentialsToCreate;

    ServicePrincipalImpl(MicrosoftGraphServicePrincipalInner innerObject, AuthorizationManager manager) {
        super(innerObject.displayName(), (Object)innerObject);
        this.manager = manager;
        this.cachedRoleAssignments = new HashMap<String, RoleAssignment>();
        this.rolesToCreate = new HashMap<String, BuiltInRole>();
        this.rolesToDelete = new HashSet<String>();
        this.cachedCertificateCredentials = new HashMap<String, CertificateCredential>();
        this.certificateCredentialsToCreate = new ArrayList();
        this.cachedPasswordCredentials = new HashMap<String, PasswordCredential>();
        this.passwordCredentialsToCreate = new ArrayList();
        this.refreshCredentials(innerObject);
    }

    @Override
    public String applicationId() {
        return ((MicrosoftGraphServicePrincipalInner)this.innerModel()).appId();
    }

    @Override
    public List<String> servicePrincipalNames() {
        return ((MicrosoftGraphServicePrincipalInner)this.innerModel()).servicePrincipalNames();
    }

    @Override
    public Map<String, PasswordCredential> passwordCredentials() {
        return Collections.unmodifiableMap(this.cachedPasswordCredentials);
    }

    @Override
    public Map<String, CertificateCredential> certificateCredentials() {
        return Collections.unmodifiableMap(this.cachedCertificateCredentials);
    }

    @Override
    public Set<RoleAssignment> roleAssignments() {
        return Collections.unmodifiableSet(new HashSet<RoleAssignment>(this.cachedRoleAssignments.values()));
    }

    protected Mono<MicrosoftGraphServicePrincipalInner> getInnerAsync() {
        return this.manager.serviceClient().getServicePrincipalsServicePrincipals().getServicePrincipalAsync(this.id()).doOnSuccess(this::refreshCredentials);
    }

    public Mono<ServicePrincipal> createResourceAsync() {
        Mono sp;
        RetryBackoffSpec retry;
        Object object = retry = this.isInCreateMode() ? RetryUtils.backoffRetryFor404ResourceNotFound() : null;
        if (this.isInCreateMode()) {
            ((MicrosoftGraphServicePrincipalInner)this.innerModel()).withAccountEnabled(true);
            if (this.applicationCreatable != null) {
                ActiveDirectoryApplication application = (ActiveDirectoryApplication)this.taskResult(this.applicationCreatable.key());
                ((MicrosoftGraphServicePrincipalInner)this.innerModel()).withAppId(application.applicationId());
            }
            sp = this.manager.serviceClient().getServicePrincipalsServicePrincipals().createServicePrincipalAsync((MicrosoftGraphServicePrincipalInner)this.innerModel()).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
            if (this.applicationCreatable != null) {
                sp = sp.retryWhen((Retry)RetryUtils.backoffRetryFor400BadRequest());
            }
        } else {
            sp = this.manager().serviceClient().getServicePrincipalsServicePrincipals().updateServicePrincipalAsync(this.id(), new MicrosoftGraphServicePrincipalInner().withKeyCredentials(((MicrosoftGraphServicePrincipalInner)this.innerModel()).keyCredentials()).withPasswordCredentials(((MicrosoftGraphServicePrincipalInner)this.innerModel()).passwordCredentials())).then(this.refreshAsync());
        }
        return sp.flatMap(arg_0 -> this.lambda$createResourceAsync$0((Retry)retry, arg_0)).map(servicePrincipal -> {
            for (PasswordCredentialImpl<?> passwordCredentialImpl : this.passwordCredentialsToCreate) {
                passwordCredentialImpl.exportAuthFile((ServicePrincipalImpl)servicePrincipal);
                passwordCredentialImpl.consumeSecret();
            }
            for (CertificateCredentialImpl certificateCredentialImpl : this.certificateCredentialsToCreate) {
                certificateCredentialImpl.exportAuthFile((ServicePrincipalImpl)servicePrincipal);
            }
            this.passwordCredentialsToCreate.clear();
            this.certificateCredentialsToCreate.clear();
            return servicePrincipal;
        });
    }

    private Mono<ServicePrincipal> submitCredentialsAsync(ServicePrincipal servicePrincipal, Retry retry) {
        return Flux.defer(() -> Flux.fromIterable(this.passwordCredentialsToCreate).flatMap(passwordCredential -> {
            Mono monoAddPassword = this.manager().serviceClient().getServicePrincipals().addPasswordAsync(this.id(), new ServicePrincipalsAddPasswordRequestBodyInner().withPasswordCredential((MicrosoftGraphPasswordCredentialInner)passwordCredential.innerModel()));
            if (retry != null) {
                monoAddPassword = monoAddPassword.retryWhen(retry);
            }
            monoAddPassword = monoAddPassword.doOnNext(arg_0 -> ((PasswordCredentialImpl)passwordCredential).setInner(arg_0));
            return monoAddPassword;
        })).then(Mono.defer(() -> {
            Mono monoRefresh = this.refreshAsync();
            if (retry != null) {
                monoRefresh = monoRefresh.retryWhen(retry);
            }
            return monoRefresh;
        }));
    }

    private Mono<ServicePrincipal> submitRolesAsync(ServicePrincipal servicePrincipal) {
        Mono create = this.rolesToCreate.isEmpty() ? Mono.just((Object)servicePrincipal) : Flux.fromIterable(this.rolesToCreate.entrySet()).flatMap(roleEntry -> ((RoleAssignment.DefinitionStages.Blank)this.manager().roleAssignments().define(this.manager().internalContext().randomUuid())).forServicePrincipal(servicePrincipal).withBuiltInRole((BuiltInRole)((Object)((Object)roleEntry.getValue()))).withScope((String)roleEntry.getKey()).createAsync()).doOnNext(indexable -> this.cachedRoleAssignments.put(indexable.id(), (RoleAssignment)indexable)).last().map(indexable -> {
            this.rolesToCreate.clear();
            return servicePrincipal;
        });
        Mono delete = this.rolesToDelete.isEmpty() ? Mono.just((Object)servicePrincipal) : Flux.fromIterable(this.rolesToDelete).flatMap(role -> this.manager().roleAssignments().deleteByIdAsync(this.cachedRoleAssignments.get(role).id()).thenReturn(role)).doOnNext(s -> this.cachedRoleAssignments.remove(s)).last().map(s -> {
            this.rolesToDelete.clear();
            return servicePrincipal;
        });
        return create.mergeWith((Publisher)delete).last();
    }

    public boolean isInCreateMode() {
        return this.id() == null;
    }

    void refreshCredentials(MicrosoftGraphServicePrincipalInner inner) {
        this.cachedCertificateCredentials.clear();
        this.cachedPasswordCredentials.clear();
        if (inner.keyCredentials() != null) {
            inner.keyCredentials().forEach(keyCredentialInner -> {
                CertificateCredentialImpl certificateCredential = new CertificateCredentialImpl((MicrosoftGraphKeyCredentialInner)keyCredentialInner);
                this.cachedCertificateCredentials.put(certificateCredential.name(), certificateCredential);
            });
        }
        if (inner.passwordCredentials() != null) {
            inner.passwordCredentials().forEach(passwordCredentialInner -> {
                PasswordCredentialImpl passwordCredential = new PasswordCredentialImpl((MicrosoftGraphPasswordCredentialInner)passwordCredentialInner);
                this.cachedPasswordCredentials.put(passwordCredential.name(), passwordCredential);
            });
        }
    }

    public Mono<ServicePrincipal> refreshAsync() {
        return this.getInnerAsync().map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public CertificateCredentialImpl<ServicePrincipalImpl> defineCertificateCredential(String name) {
        return new CertificateCredentialImpl<ServicePrincipalImpl>(name, this);
    }

    public PasswordCredentialImpl<ServicePrincipalImpl> definePasswordCredential(String name) {
        return new PasswordCredentialImpl<ServicePrincipalImpl>(name, this);
    }

    @Override
    public ServicePrincipalImpl withoutCredential(String name) {
        if (this.cachedPasswordCredentials.containsKey(name)) {
            ((MicrosoftGraphServicePrincipalInner)this.innerModel()).passwordCredentials().remove(this.cachedPasswordCredentials.get(name).innerModel());
        } else if (this.cachedCertificateCredentials.containsKey(name)) {
            ((MicrosoftGraphServicePrincipalInner)this.innerModel()).keyCredentials().remove(this.cachedCertificateCredentials.get(name).innerModel());
        }
        return this;
    }

    @Override
    public ServicePrincipalImpl withCertificateCredential(CertificateCredentialImpl<?> credential) {
        this.certificateCredentialsToCreate.add(credential);
        if (((MicrosoftGraphServicePrincipalInner)this.innerModel()).keyCredentials() == null) {
            ((MicrosoftGraphServicePrincipalInner)this.innerModel()).withKeyCredentials(new ArrayList<MicrosoftGraphKeyCredentialInner>());
        }
        ((MicrosoftGraphServicePrincipalInner)this.innerModel()).keyCredentials().add((MicrosoftGraphKeyCredentialInner)credential.innerModel());
        return this;
    }

    @Override
    public ServicePrincipalImpl withPasswordCredential(PasswordCredentialImpl<?> credential) {
        this.passwordCredentialsToCreate.add(credential);
        return this;
    }

    @Override
    public ServicePrincipalImpl withExistingApplication(String id) {
        ((MicrosoftGraphServicePrincipalInner)this.innerModel()).withAppId(id);
        return this;
    }

    @Override
    public ServicePrincipalImpl withExistingApplication(ActiveDirectoryApplication application) {
        ((MicrosoftGraphServicePrincipalInner)this.innerModel()).withAppId(application.applicationId());
        return this;
    }

    @Override
    public ServicePrincipalImpl withNewApplication(Creatable<ActiveDirectoryApplication> applicationCreatable) {
        this.addDependency(applicationCreatable);
        this.applicationCreatable = applicationCreatable;
        return this;
    }

    @Override
    public ServicePrincipalImpl withNewApplication(String signOnUrl) {
        return this.withNewApplication(((ActiveDirectoryApplication.DefinitionStages.Blank)this.manager.applications().define(this.name())).withSignOnUrl(signOnUrl).withIdentifierUrl(signOnUrl));
    }

    @Override
    public ServicePrincipalImpl withNewApplication() {
        return this.withNewApplication((Creatable)this.manager.applications().define(this.name()));
    }

    @Override
    public ServicePrincipalImpl withNewRole(BuiltInRole role, String scope) {
        this.rolesToCreate.put(scope, role);
        return this;
    }

    @Override
    public ServicePrincipalImpl withNewRoleInSubscription(BuiltInRole role, String subscriptionId) {
        this.assignedSubscription = subscriptionId;
        return this.withNewRole(role, "subscriptions/" + subscriptionId);
    }

    @Override
    public ServicePrincipalImpl withNewRoleInResourceGroup(BuiltInRole role, ResourceGroup resourceGroup) {
        return this.withNewRole(role, resourceGroup.id());
    }

    @Override
    public ServicePrincipal.Update withoutRole(RoleAssignment roleAssignment) {
        this.rolesToDelete.add(roleAssignment.id());
        return this;
    }

    public String id() {
        return ((MicrosoftGraphServicePrincipalInner)this.innerModel()).id();
    }

    public AuthorizationManager manager() {
        return this.manager;
    }

    private /* synthetic */ Mono lambda$createResourceAsync$0(Retry retry, ServicePrincipal servicePrincipal) {
        return this.submitCredentialsAsync(servicePrincipal, retry).mergeWith(this.submitRolesAsync(servicePrincipal)).last();
    }
}

