/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphChangeTrackedEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphShiftItem;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphShift
extends MicrosoftGraphChangeTrackedEntity {
    private MicrosoftGraphShiftItem draftShift;
    private String schedulingGroupId;
    private MicrosoftGraphShiftItem sharedShift;
    private String userId;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphShiftItem draftShift() {
        return this.draftShift;
    }

    public MicrosoftGraphShift withDraftShift(MicrosoftGraphShiftItem draftShift) {
        this.draftShift = draftShift;
        return this;
    }

    public String schedulingGroupId() {
        return this.schedulingGroupId;
    }

    public MicrosoftGraphShift withSchedulingGroupId(String schedulingGroupId) {
        this.schedulingGroupId = schedulingGroupId;
        return this;
    }

    public MicrosoftGraphShiftItem sharedShift() {
        return this.sharedShift;
    }

    public MicrosoftGraphShift withSharedShift(MicrosoftGraphShiftItem sharedShift) {
        this.sharedShift = sharedShift;
        return this;
    }

    public String userId() {
        return this.userId;
    }

    public MicrosoftGraphShift withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphShift withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphShift withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphShift withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    @Override
    public MicrosoftGraphShift withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphShift withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.draftShift() != null) {
            this.draftShift().validate();
        }
        if (this.sharedShift() != null) {
            this.sharedShift().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime()));
        jsonWriter.writeJsonField("lastModifiedBy", (JsonSerializable)this.lastModifiedBy());
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime()));
        jsonWriter.writeJsonField("draftShift", (JsonSerializable)this.draftShift);
        jsonWriter.writeStringField("schedulingGroupId", this.schedulingGroupId);
        jsonWriter.writeJsonField("sharedShift", (JsonSerializable)this.sharedShift);
        jsonWriter.writeStringField("userId", this.userId);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphShift fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphShift)jsonReader.readObject(reader -> {
            MicrosoftGraphShift deserializedMicrosoftGraphShift = new MicrosoftGraphShift();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphShift.withId(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphShift.withCreatedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphShift.withLastModifiedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphShift.withLastModifiedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("draftShift".equals(fieldName)) {
                    deserializedMicrosoftGraphShift.draftShift = MicrosoftGraphShiftItem.fromJson(reader);
                    continue;
                }
                if ("schedulingGroupId".equals(fieldName)) {
                    deserializedMicrosoftGraphShift.schedulingGroupId = reader.getString();
                    continue;
                }
                if ("sharedShift".equals(fieldName)) {
                    deserializedMicrosoftGraphShift.sharedShift = MicrosoftGraphShiftItem.fromJson(reader);
                    continue;
                }
                if ("userId".equals(fieldName)) {
                    deserializedMicrosoftGraphShift.userId = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphShift.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphShift;
        });
    }
}

