/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphCalculatedColumn;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphChoiceColumn;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphCurrencyColumn;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDateTimeColumn;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDefaultColumnValue;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphLookupColumn;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphNumberColumn;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPersonOrGroupColumn;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTextColumn;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphColumnDefinition
extends MicrosoftGraphEntity {
    private Map<String, Object> booleanProperty;
    private MicrosoftGraphCalculatedColumn calculated;
    private MicrosoftGraphChoiceColumn choice;
    private String columnGroup;
    private MicrosoftGraphCurrencyColumn currency;
    private MicrosoftGraphDateTimeColumn dateTime;
    private MicrosoftGraphDefaultColumnValue defaultValue;
    private String description;
    private String displayName;
    private Boolean enforceUniqueValues;
    private Map<String, Object> geolocation;
    private Boolean hidden;
    private Boolean indexed;
    private MicrosoftGraphLookupColumn lookup;
    private String name;
    private MicrosoftGraphNumberColumn number;
    private MicrosoftGraphPersonOrGroupColumn personOrGroup;
    private Boolean readOnly;
    private Boolean required;
    private MicrosoftGraphTextColumn text;
    private Map<String, Object> additionalProperties;

    public Map<String, Object> booleanProperty() {
        return this.booleanProperty;
    }

    public MicrosoftGraphColumnDefinition withBooleanProperty(Map<String, Object> booleanProperty) {
        this.booleanProperty = booleanProperty;
        return this;
    }

    public MicrosoftGraphCalculatedColumn calculated() {
        return this.calculated;
    }

    public MicrosoftGraphColumnDefinition withCalculated(MicrosoftGraphCalculatedColumn calculated) {
        this.calculated = calculated;
        return this;
    }

    public MicrosoftGraphChoiceColumn choice() {
        return this.choice;
    }

    public MicrosoftGraphColumnDefinition withChoice(MicrosoftGraphChoiceColumn choice) {
        this.choice = choice;
        return this;
    }

    public String columnGroup() {
        return this.columnGroup;
    }

    public MicrosoftGraphColumnDefinition withColumnGroup(String columnGroup) {
        this.columnGroup = columnGroup;
        return this;
    }

    public MicrosoftGraphCurrencyColumn currency() {
        return this.currency;
    }

    public MicrosoftGraphColumnDefinition withCurrency(MicrosoftGraphCurrencyColumn currency) {
        this.currency = currency;
        return this;
    }

    public MicrosoftGraphDateTimeColumn dateTime() {
        return this.dateTime;
    }

    public MicrosoftGraphColumnDefinition withDateTime(MicrosoftGraphDateTimeColumn dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    public MicrosoftGraphDefaultColumnValue defaultValue() {
        return this.defaultValue;
    }

    public MicrosoftGraphColumnDefinition withDefaultValue(MicrosoftGraphDefaultColumnValue defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public String description() {
        return this.description;
    }

    public MicrosoftGraphColumnDefinition withDescription(String description) {
        this.description = description;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphColumnDefinition withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Boolean enforceUniqueValues() {
        return this.enforceUniqueValues;
    }

    public MicrosoftGraphColumnDefinition withEnforceUniqueValues(Boolean enforceUniqueValues) {
        this.enforceUniqueValues = enforceUniqueValues;
        return this;
    }

    public Map<String, Object> geolocation() {
        return this.geolocation;
    }

    public MicrosoftGraphColumnDefinition withGeolocation(Map<String, Object> geolocation) {
        this.geolocation = geolocation;
        return this;
    }

    public Boolean hidden() {
        return this.hidden;
    }

    public MicrosoftGraphColumnDefinition withHidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public Boolean indexed() {
        return this.indexed;
    }

    public MicrosoftGraphColumnDefinition withIndexed(Boolean indexed) {
        this.indexed = indexed;
        return this;
    }

    public MicrosoftGraphLookupColumn lookup() {
        return this.lookup;
    }

    public MicrosoftGraphColumnDefinition withLookup(MicrosoftGraphLookupColumn lookup) {
        this.lookup = lookup;
        return this;
    }

    public String name() {
        return this.name;
    }

    public MicrosoftGraphColumnDefinition withName(String name) {
        this.name = name;
        return this;
    }

    public MicrosoftGraphNumberColumn number() {
        return this.number;
    }

    public MicrosoftGraphColumnDefinition withNumber(MicrosoftGraphNumberColumn number) {
        this.number = number;
        return this;
    }

    public MicrosoftGraphPersonOrGroupColumn personOrGroup() {
        return this.personOrGroup;
    }

    public MicrosoftGraphColumnDefinition withPersonOrGroup(MicrosoftGraphPersonOrGroupColumn personOrGroup) {
        this.personOrGroup = personOrGroup;
        return this;
    }

    public Boolean readOnly() {
        return this.readOnly;
    }

    public MicrosoftGraphColumnDefinition withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public Boolean required() {
        return this.required;
    }

    public MicrosoftGraphColumnDefinition withRequired(Boolean required) {
        this.required = required;
        return this;
    }

    public MicrosoftGraphTextColumn text() {
        return this.text;
    }

    public MicrosoftGraphColumnDefinition withText(MicrosoftGraphTextColumn text) {
        this.text = text;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphColumnDefinition withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphColumnDefinition withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.calculated() != null) {
            this.calculated().validate();
        }
        if (this.choice() != null) {
            this.choice().validate();
        }
        if (this.currency() != null) {
            this.currency().validate();
        }
        if (this.dateTime() != null) {
            this.dateTime().validate();
        }
        if (this.defaultValue() != null) {
            this.defaultValue().validate();
        }
        if (this.lookup() != null) {
            this.lookup().validate();
        }
        if (this.number() != null) {
            this.number().validate();
        }
        if (this.personOrGroup() != null) {
            this.personOrGroup().validate();
        }
        if (this.text() != null) {
            this.text().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeMapField("boolean", this.booleanProperty, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("calculated", (JsonSerializable)this.calculated);
        jsonWriter.writeJsonField("choice", (JsonSerializable)this.choice);
        jsonWriter.writeStringField("columnGroup", this.columnGroup);
        jsonWriter.writeJsonField("currency", (JsonSerializable)this.currency);
        jsonWriter.writeJsonField("dateTime", (JsonSerializable)this.dateTime);
        jsonWriter.writeJsonField("defaultValue", (JsonSerializable)this.defaultValue);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeBooleanField("enforceUniqueValues", this.enforceUniqueValues);
        jsonWriter.writeMapField("geolocation", this.geolocation, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeBooleanField("hidden", this.hidden);
        jsonWriter.writeBooleanField("indexed", this.indexed);
        jsonWriter.writeJsonField("lookup", (JsonSerializable)this.lookup);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("number", (JsonSerializable)this.number);
        jsonWriter.writeJsonField("personOrGroup", (JsonSerializable)this.personOrGroup);
        jsonWriter.writeBooleanField("readOnly", this.readOnly);
        jsonWriter.writeBooleanField("required", this.required);
        jsonWriter.writeJsonField("text", (JsonSerializable)this.text);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphColumnDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphColumnDefinition)jsonReader.readObject(reader -> {
            MicrosoftGraphColumnDefinition deserializedMicrosoftGraphColumnDefinition = new MicrosoftGraphColumnDefinition();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.withId(reader.getString());
                    continue;
                }
                if ("boolean".equals(fieldName)) {
                    Map booleanProperty;
                    deserializedMicrosoftGraphColumnDefinition.booleanProperty = booleanProperty = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("calculated".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.calculated = MicrosoftGraphCalculatedColumn.fromJson(reader);
                    continue;
                }
                if ("choice".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.choice = MicrosoftGraphChoiceColumn.fromJson(reader);
                    continue;
                }
                if ("columnGroup".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.columnGroup = reader.getString();
                    continue;
                }
                if ("currency".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.currency = MicrosoftGraphCurrencyColumn.fromJson(reader);
                    continue;
                }
                if ("dateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.dateTime = MicrosoftGraphDateTimeColumn.fromJson(reader);
                    continue;
                }
                if ("defaultValue".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.defaultValue = MicrosoftGraphDefaultColumnValue.fromJson(reader);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.description = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.displayName = reader.getString();
                    continue;
                }
                if ("enforceUniqueValues".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.enforceUniqueValues = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("geolocation".equals(fieldName)) {
                    Map geolocation;
                    deserializedMicrosoftGraphColumnDefinition.geolocation = geolocation = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("hidden".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.hidden = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("indexed".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.indexed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("lookup".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.lookup = MicrosoftGraphLookupColumn.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.name = reader.getString();
                    continue;
                }
                if ("number".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.number = MicrosoftGraphNumberColumn.fromJson(reader);
                    continue;
                }
                if ("personOrGroup".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.personOrGroup = MicrosoftGraphPersonOrGroupColumn.fromJson(reader);
                    continue;
                }
                if ("readOnly".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.readOnly = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("required".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.required = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("text".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.text = MicrosoftGraphTextColumn.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphColumnDefinition.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphColumnDefinition;
        });
    }
}

