/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphChangeTrackedEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTimeOffReasonIconType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphTimeOffReason
extends MicrosoftGraphChangeTrackedEntity {
    private String displayName;
    private MicrosoftGraphTimeOffReasonIconType iconType;
    private Boolean isActive;
    private Map<String, Object> additionalProperties;

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphTimeOffReason withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public MicrosoftGraphTimeOffReasonIconType iconType() {
        return this.iconType;
    }

    public MicrosoftGraphTimeOffReason withIconType(MicrosoftGraphTimeOffReasonIconType iconType) {
        this.iconType = iconType;
        return this;
    }

    public Boolean isActive() {
        return this.isActive;
    }

    public MicrosoftGraphTimeOffReason withIsActive(Boolean isActive) {
        this.isActive = isActive;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphTimeOffReason withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphTimeOffReason withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphTimeOffReason withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    @Override
    public MicrosoftGraphTimeOffReason withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphTimeOffReason withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime()));
        jsonWriter.writeJsonField("lastModifiedBy", (JsonSerializable)this.lastModifiedBy());
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime()));
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("iconType", this.iconType == null ? null : this.iconType.toString());
        jsonWriter.writeBooleanField("isActive", this.isActive);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphTimeOffReason fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphTimeOffReason)jsonReader.readObject(reader -> {
            MicrosoftGraphTimeOffReason deserializedMicrosoftGraphTimeOffReason = new MicrosoftGraphTimeOffReason();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffReason.withId(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffReason.withCreatedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffReason.withLastModifiedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffReason.withLastModifiedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffReason.displayName = reader.getString();
                    continue;
                }
                if ("iconType".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffReason.iconType = MicrosoftGraphTimeOffReasonIconType.fromString(reader.getString());
                    continue;
                }
                if ("isActive".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffReason.isActive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphTimeOffReason.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphTimeOffReason;
        });
    }
}

