/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphChangeTrackedEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOpenShiftItem;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphOpenShift
extends MicrosoftGraphChangeTrackedEntity {
    private MicrosoftGraphOpenShiftItem draftOpenShift;
    private String schedulingGroupId;
    private MicrosoftGraphOpenShiftItem sharedOpenShift;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphOpenShiftItem draftOpenShift() {
        return this.draftOpenShift;
    }

    public MicrosoftGraphOpenShift withDraftOpenShift(MicrosoftGraphOpenShiftItem draftOpenShift) {
        this.draftOpenShift = draftOpenShift;
        return this;
    }

    public String schedulingGroupId() {
        return this.schedulingGroupId;
    }

    public MicrosoftGraphOpenShift withSchedulingGroupId(String schedulingGroupId) {
        this.schedulingGroupId = schedulingGroupId;
        return this;
    }

    public MicrosoftGraphOpenShiftItem sharedOpenShift() {
        return this.sharedOpenShift;
    }

    public MicrosoftGraphOpenShift withSharedOpenShift(MicrosoftGraphOpenShiftItem sharedOpenShift) {
        this.sharedOpenShift = sharedOpenShift;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphOpenShift withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphOpenShift withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphOpenShift withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    @Override
    public MicrosoftGraphOpenShift withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphOpenShift withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.draftOpenShift() != null) {
            this.draftOpenShift().validate();
        }
        if (this.sharedOpenShift() != null) {
            this.sharedOpenShift().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime()));
        jsonWriter.writeJsonField("lastModifiedBy", (JsonSerializable)this.lastModifiedBy());
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime()));
        jsonWriter.writeJsonField("draftOpenShift", (JsonSerializable)this.draftOpenShift);
        jsonWriter.writeStringField("schedulingGroupId", this.schedulingGroupId);
        jsonWriter.writeJsonField("sharedOpenShift", (JsonSerializable)this.sharedOpenShift);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphOpenShift fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphOpenShift)jsonReader.readObject(reader -> {
            MicrosoftGraphOpenShift deserializedMicrosoftGraphOpenShift = new MicrosoftGraphOpenShift();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphOpenShift.withId(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOpenShift.withCreatedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphOpenShift.withLastModifiedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOpenShift.withLastModifiedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("draftOpenShift".equals(fieldName)) {
                    deserializedMicrosoftGraphOpenShift.draftOpenShift = MicrosoftGraphOpenShiftItem.fromJson(reader);
                    continue;
                }
                if ("schedulingGroupId".equals(fieldName)) {
                    deserializedMicrosoftGraphOpenShift.schedulingGroupId = reader.getString();
                    continue;
                }
                if ("sharedOpenShift".equals(fieldName)) {
                    deserializedMicrosoftGraphOpenShift.sharedOpenShift = MicrosoftGraphOpenShiftItem.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphOpenShift.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphOpenShift;
        });
    }
}

