/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphWorkbookChartAxisFormat;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphWorkbookChartAxisTitle;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphWorkbookChartGridlines;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphWorkbookChartAxis
extends MicrosoftGraphEntity {
    private Map<String, Object> majorUnit;
    private Map<String, Object> maximum;
    private Map<String, Object> minimum;
    private Map<String, Object> minorUnit;
    private MicrosoftGraphWorkbookChartAxisFormat format;
    private MicrosoftGraphWorkbookChartGridlines majorGridlines;
    private MicrosoftGraphWorkbookChartGridlines minorGridlines;
    private MicrosoftGraphWorkbookChartAxisTitle title;
    private Map<String, Object> additionalProperties;

    public Map<String, Object> majorUnit() {
        return this.majorUnit;
    }

    public MicrosoftGraphWorkbookChartAxis withMajorUnit(Map<String, Object> majorUnit) {
        this.majorUnit = majorUnit;
        return this;
    }

    public Map<String, Object> maximum() {
        return this.maximum;
    }

    public MicrosoftGraphWorkbookChartAxis withMaximum(Map<String, Object> maximum) {
        this.maximum = maximum;
        return this;
    }

    public Map<String, Object> minimum() {
        return this.minimum;
    }

    public MicrosoftGraphWorkbookChartAxis withMinimum(Map<String, Object> minimum) {
        this.minimum = minimum;
        return this;
    }

    public Map<String, Object> minorUnit() {
        return this.minorUnit;
    }

    public MicrosoftGraphWorkbookChartAxis withMinorUnit(Map<String, Object> minorUnit) {
        this.minorUnit = minorUnit;
        return this;
    }

    public MicrosoftGraphWorkbookChartAxisFormat format() {
        return this.format;
    }

    public MicrosoftGraphWorkbookChartAxis withFormat(MicrosoftGraphWorkbookChartAxisFormat format) {
        this.format = format;
        return this;
    }

    public MicrosoftGraphWorkbookChartGridlines majorGridlines() {
        return this.majorGridlines;
    }

    public MicrosoftGraphWorkbookChartAxis withMajorGridlines(MicrosoftGraphWorkbookChartGridlines majorGridlines) {
        this.majorGridlines = majorGridlines;
        return this;
    }

    public MicrosoftGraphWorkbookChartGridlines minorGridlines() {
        return this.minorGridlines;
    }

    public MicrosoftGraphWorkbookChartAxis withMinorGridlines(MicrosoftGraphWorkbookChartGridlines minorGridlines) {
        this.minorGridlines = minorGridlines;
        return this;
    }

    public MicrosoftGraphWorkbookChartAxisTitle title() {
        return this.title;
    }

    public MicrosoftGraphWorkbookChartAxis withTitle(MicrosoftGraphWorkbookChartAxisTitle title) {
        this.title = title;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphWorkbookChartAxis withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphWorkbookChartAxis withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.format() != null) {
            this.format().validate();
        }
        if (this.majorGridlines() != null) {
            this.majorGridlines().validate();
        }
        if (this.minorGridlines() != null) {
            this.minorGridlines().validate();
        }
        if (this.title() != null) {
            this.title().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeMapField("majorUnit", this.majorUnit, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeMapField("maximum", this.maximum, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeMapField("minimum", this.minimum, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeMapField("minorUnit", this.minorUnit, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("format", (JsonSerializable)this.format);
        jsonWriter.writeJsonField("majorGridlines", (JsonSerializable)this.majorGridlines);
        jsonWriter.writeJsonField("minorGridlines", (JsonSerializable)this.minorGridlines);
        jsonWriter.writeJsonField("title", (JsonSerializable)this.title);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphWorkbookChartAxis fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphWorkbookChartAxis)jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookChartAxis deserializedMicrosoftGraphWorkbookChartAxis = new MicrosoftGraphWorkbookChartAxis();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartAxis.withId(reader.getString());
                    continue;
                }
                if ("majorUnit".equals(fieldName)) {
                    Map majorUnit;
                    deserializedMicrosoftGraphWorkbookChartAxis.majorUnit = majorUnit = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("maximum".equals(fieldName)) {
                    Map maximum;
                    deserializedMicrosoftGraphWorkbookChartAxis.maximum = maximum = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("minimum".equals(fieldName)) {
                    Map minimum;
                    deserializedMicrosoftGraphWorkbookChartAxis.minimum = minimum = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("minorUnit".equals(fieldName)) {
                    Map minorUnit;
                    deserializedMicrosoftGraphWorkbookChartAxis.minorUnit = minorUnit = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartAxis.format = MicrosoftGraphWorkbookChartAxisFormat.fromJson(reader);
                    continue;
                }
                if ("majorGridlines".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartAxis.majorGridlines = MicrosoftGraphWorkbookChartGridlines.fromJson(reader);
                    continue;
                }
                if ("minorGridlines".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartAxis.minorGridlines = MicrosoftGraphWorkbookChartGridlines.fromJson(reader);
                    continue;
                }
                if ("title".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartAxis.title = MicrosoftGraphWorkbookChartAxisTitle.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphWorkbookChartAxis.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphWorkbookChartAxis;
        });
    }
}

