/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphImplicitGrantSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphWebApplication
implements JsonSerializable<MicrosoftGraphWebApplication> {
    private String homePageUrl;
    private MicrosoftGraphImplicitGrantSettings implicitGrantSettings;
    private String logoutUrl;
    private List<String> redirectUris;
    private Map<String, Object> additionalProperties;

    public String homePageUrl() {
        return this.homePageUrl;
    }

    public MicrosoftGraphWebApplication withHomePageUrl(String homePageUrl) {
        this.homePageUrl = homePageUrl;
        return this;
    }

    public MicrosoftGraphImplicitGrantSettings implicitGrantSettings() {
        return this.implicitGrantSettings;
    }

    public MicrosoftGraphWebApplication withImplicitGrantSettings(MicrosoftGraphImplicitGrantSettings implicitGrantSettings) {
        this.implicitGrantSettings = implicitGrantSettings;
        return this;
    }

    public String logoutUrl() {
        return this.logoutUrl;
    }

    public MicrosoftGraphWebApplication withLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
        return this;
    }

    public List<String> redirectUris() {
        return this.redirectUris;
    }

    public MicrosoftGraphWebApplication withRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphWebApplication withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.implicitGrantSettings() != null) {
            this.implicitGrantSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("homePageUrl", this.homePageUrl);
        jsonWriter.writeJsonField("implicitGrantSettings", (JsonSerializable)this.implicitGrantSettings);
        jsonWriter.writeStringField("logoutUrl", this.logoutUrl);
        jsonWriter.writeArrayField("redirectUris", this.redirectUris, (writer, element) -> writer.writeString(element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphWebApplication fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphWebApplication)jsonReader.readObject(reader -> {
            MicrosoftGraphWebApplication deserializedMicrosoftGraphWebApplication = new MicrosoftGraphWebApplication();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("homePageUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphWebApplication.homePageUrl = reader.getString();
                    continue;
                }
                if ("implicitGrantSettings".equals(fieldName)) {
                    deserializedMicrosoftGraphWebApplication.implicitGrantSettings = MicrosoftGraphImplicitGrantSettings.fromJson(reader);
                    continue;
                }
                if ("logoutUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphWebApplication.logoutUrl = reader.getString();
                    continue;
                }
                if ("redirectUris".equals(fieldName)) {
                    List redirectUris;
                    deserializedMicrosoftGraphWebApplication.redirectUris = redirectUris = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphWebApplication.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphWebApplication;
        });
    }
}

