/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphAttachment;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtension;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphFollowupFlag;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphImportance;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphInferenceClassificationType;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphInternetMessageHeader;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphItemBody;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphMultiValueLegacyExtendedProperty;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOutlookItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphRecipient;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSingleValueLegacyExtendedProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class MicrosoftGraphMessage
extends MicrosoftGraphOutlookItem {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private List<MicrosoftGraphRecipient> bccRecipients;
    private MicrosoftGraphItemBody body;
    private String bodyPreview;
    private List<MicrosoftGraphRecipient> ccRecipients;
    private String conversationId;
    private Base64Url conversationIndex;
    private MicrosoftGraphFollowupFlag flag;
    private MicrosoftGraphRecipient from;
    private Boolean hasAttachments;
    private MicrosoftGraphImportance importance;
    private MicrosoftGraphInferenceClassificationType inferenceClassification;
    private List<MicrosoftGraphInternetMessageHeader> internetMessageHeaders;
    private String internetMessageId;
    private Boolean isDeliveryReceiptRequested;
    private Boolean isDraft;
    private Boolean isRead;
    private Boolean isReadReceiptRequested;
    private String parentFolderId;
    private OffsetDateTime receivedDateTime;
    private List<MicrosoftGraphRecipient> replyTo;
    private MicrosoftGraphRecipient sender;
    private OffsetDateTime sentDateTime;
    private String subject;
    private List<MicrosoftGraphRecipient> toRecipients;
    private MicrosoftGraphItemBody uniqueBody;
    private String webLink;
    private List<MicrosoftGraphAttachment> attachments;
    private List<MicrosoftGraphExtension> extensions;
    private List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties;
    private List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties;
    private Map<String, Object> additionalProperties;

    public List<MicrosoftGraphRecipient> bccRecipients() {
        return this.bccRecipients;
    }

    public MicrosoftGraphMessage withBccRecipients(List<MicrosoftGraphRecipient> bccRecipients) {
        this.bccRecipients = bccRecipients;
        return this;
    }

    public MicrosoftGraphItemBody body() {
        return this.body;
    }

    public MicrosoftGraphMessage withBody(MicrosoftGraphItemBody body) {
        this.body = body;
        return this;
    }

    public String bodyPreview() {
        return this.bodyPreview;
    }

    public MicrosoftGraphMessage withBodyPreview(String bodyPreview) {
        this.bodyPreview = bodyPreview;
        return this;
    }

    public List<MicrosoftGraphRecipient> ccRecipients() {
        return this.ccRecipients;
    }

    public MicrosoftGraphMessage withCcRecipients(List<MicrosoftGraphRecipient> ccRecipients) {
        this.ccRecipients = ccRecipients;
        return this;
    }

    public String conversationId() {
        return this.conversationId;
    }

    public MicrosoftGraphMessage withConversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    public byte[] conversationIndex() {
        if (this.conversationIndex == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return this.conversationIndex.decodedBytes();
    }

    public MicrosoftGraphMessage withConversationIndex(byte[] conversationIndex) {
        this.conversationIndex = conversationIndex == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])conversationIndex));
        return this;
    }

    public MicrosoftGraphFollowupFlag flag() {
        return this.flag;
    }

    public MicrosoftGraphMessage withFlag(MicrosoftGraphFollowupFlag flag) {
        this.flag = flag;
        return this;
    }

    public MicrosoftGraphRecipient from() {
        return this.from;
    }

    public MicrosoftGraphMessage withFrom(MicrosoftGraphRecipient from) {
        this.from = from;
        return this;
    }

    public Boolean hasAttachments() {
        return this.hasAttachments;
    }

    public MicrosoftGraphMessage withHasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
        return this;
    }

    public MicrosoftGraphImportance importance() {
        return this.importance;
    }

    public MicrosoftGraphMessage withImportance(MicrosoftGraphImportance importance) {
        this.importance = importance;
        return this;
    }

    public MicrosoftGraphInferenceClassificationType inferenceClassification() {
        return this.inferenceClassification;
    }

    public MicrosoftGraphMessage withInferenceClassification(MicrosoftGraphInferenceClassificationType inferenceClassification) {
        this.inferenceClassification = inferenceClassification;
        return this;
    }

    public List<MicrosoftGraphInternetMessageHeader> internetMessageHeaders() {
        return this.internetMessageHeaders;
    }

    public MicrosoftGraphMessage withInternetMessageHeaders(List<MicrosoftGraphInternetMessageHeader> internetMessageHeaders) {
        this.internetMessageHeaders = internetMessageHeaders;
        return this;
    }

    public String internetMessageId() {
        return this.internetMessageId;
    }

    public MicrosoftGraphMessage withInternetMessageId(String internetMessageId) {
        this.internetMessageId = internetMessageId;
        return this;
    }

    public Boolean isDeliveryReceiptRequested() {
        return this.isDeliveryReceiptRequested;
    }

    public MicrosoftGraphMessage withIsDeliveryReceiptRequested(Boolean isDeliveryReceiptRequested) {
        this.isDeliveryReceiptRequested = isDeliveryReceiptRequested;
        return this;
    }

    public Boolean isDraft() {
        return this.isDraft;
    }

    public MicrosoftGraphMessage withIsDraft(Boolean isDraft) {
        this.isDraft = isDraft;
        return this;
    }

    public Boolean isRead() {
        return this.isRead;
    }

    public MicrosoftGraphMessage withIsRead(Boolean isRead) {
        this.isRead = isRead;
        return this;
    }

    public Boolean isReadReceiptRequested() {
        return this.isReadReceiptRequested;
    }

    public MicrosoftGraphMessage withIsReadReceiptRequested(Boolean isReadReceiptRequested) {
        this.isReadReceiptRequested = isReadReceiptRequested;
        return this;
    }

    public String parentFolderId() {
        return this.parentFolderId;
    }

    public MicrosoftGraphMessage withParentFolderId(String parentFolderId) {
        this.parentFolderId = parentFolderId;
        return this;
    }

    public OffsetDateTime receivedDateTime() {
        return this.receivedDateTime;
    }

    public MicrosoftGraphMessage withReceivedDateTime(OffsetDateTime receivedDateTime) {
        this.receivedDateTime = receivedDateTime;
        return this;
    }

    public List<MicrosoftGraphRecipient> replyTo() {
        return this.replyTo;
    }

    public MicrosoftGraphMessage withReplyTo(List<MicrosoftGraphRecipient> replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    public MicrosoftGraphRecipient sender() {
        return this.sender;
    }

    public MicrosoftGraphMessage withSender(MicrosoftGraphRecipient sender) {
        this.sender = sender;
        return this;
    }

    public OffsetDateTime sentDateTime() {
        return this.sentDateTime;
    }

    public MicrosoftGraphMessage withSentDateTime(OffsetDateTime sentDateTime) {
        this.sentDateTime = sentDateTime;
        return this;
    }

    public String subject() {
        return this.subject;
    }

    public MicrosoftGraphMessage withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public List<MicrosoftGraphRecipient> toRecipients() {
        return this.toRecipients;
    }

    public MicrosoftGraphMessage withToRecipients(List<MicrosoftGraphRecipient> toRecipients) {
        this.toRecipients = toRecipients;
        return this;
    }

    public MicrosoftGraphItemBody uniqueBody() {
        return this.uniqueBody;
    }

    public MicrosoftGraphMessage withUniqueBody(MicrosoftGraphItemBody uniqueBody) {
        this.uniqueBody = uniqueBody;
        return this;
    }

    public String webLink() {
        return this.webLink;
    }

    public MicrosoftGraphMessage withWebLink(String webLink) {
        this.webLink = webLink;
        return this;
    }

    public List<MicrosoftGraphAttachment> attachments() {
        return this.attachments;
    }

    public MicrosoftGraphMessage withAttachments(List<MicrosoftGraphAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public List<MicrosoftGraphExtension> extensions() {
        return this.extensions;
    }

    public MicrosoftGraphMessage withExtensions(List<MicrosoftGraphExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    public List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties() {
        return this.multiValueExtendedProperties;
    }

    public MicrosoftGraphMessage withMultiValueExtendedProperties(List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
        this.multiValueExtendedProperties = multiValueExtendedProperties;
        return this;
    }

    public List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties() {
        return this.singleValueExtendedProperties;
    }

    public MicrosoftGraphMessage withSingleValueExtendedProperties(List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
        this.singleValueExtendedProperties = singleValueExtendedProperties;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphMessage withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphMessage withCategories(List<String> categories) {
        super.withCategories(categories);
        return this;
    }

    @Override
    public MicrosoftGraphMessage withChangeKey(String changeKey) {
        super.withChangeKey(changeKey);
        return this;
    }

    @Override
    public MicrosoftGraphMessage withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphMessage withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphMessage withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.bccRecipients() != null) {
            this.bccRecipients().forEach(e -> e.validate());
        }
        if (this.body() != null) {
            this.body().validate();
        }
        if (this.ccRecipients() != null) {
            this.ccRecipients().forEach(e -> e.validate());
        }
        if (this.flag() != null) {
            this.flag().validate();
        }
        if (this.from() != null) {
            this.from().validate();
        }
        if (this.internetMessageHeaders() != null) {
            this.internetMessageHeaders().forEach(e -> e.validate());
        }
        if (this.replyTo() != null) {
            this.replyTo().forEach(e -> e.validate());
        }
        if (this.sender() != null) {
            this.sender().validate();
        }
        if (this.toRecipients() != null) {
            this.toRecipients().forEach(e -> e.validate());
        }
        if (this.uniqueBody() != null) {
            this.uniqueBody().validate();
        }
        if (this.attachments() != null) {
            this.attachments().forEach(e -> e.validate());
        }
        if (this.extensions() != null) {
            this.extensions().forEach(e -> e.validate());
        }
        if (this.multiValueExtendedProperties() != null) {
            this.multiValueExtendedProperties().forEach(e -> e.validate());
        }
        if (this.singleValueExtendedProperties() != null) {
            this.singleValueExtendedProperties().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeArrayField("categories", this.categories(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("changeKey", this.changeKey());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime()));
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime()));
        jsonWriter.writeArrayField("bccRecipients", this.bccRecipients, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("body", (JsonSerializable)this.body);
        jsonWriter.writeStringField("bodyPreview", this.bodyPreview);
        jsonWriter.writeArrayField("ccRecipients", this.ccRecipients, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("conversationId", this.conversationId);
        jsonWriter.writeStringField("conversationIndex", Objects.toString(this.conversationIndex, null));
        jsonWriter.writeJsonField("flag", (JsonSerializable)this.flag);
        jsonWriter.writeJsonField("from", (JsonSerializable)this.from);
        jsonWriter.writeBooleanField("hasAttachments", this.hasAttachments);
        jsonWriter.writeStringField("importance", this.importance == null ? null : this.importance.toString());
        jsonWriter.writeStringField("inferenceClassification", this.inferenceClassification == null ? null : this.inferenceClassification.toString());
        jsonWriter.writeArrayField("internetMessageHeaders", this.internetMessageHeaders, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("internetMessageId", this.internetMessageId);
        jsonWriter.writeBooleanField("isDeliveryReceiptRequested", this.isDeliveryReceiptRequested);
        jsonWriter.writeBooleanField("isDraft", this.isDraft);
        jsonWriter.writeBooleanField("isRead", this.isRead);
        jsonWriter.writeBooleanField("isReadReceiptRequested", this.isReadReceiptRequested);
        jsonWriter.writeStringField("parentFolderId", this.parentFolderId);
        jsonWriter.writeStringField("receivedDateTime", this.receivedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.receivedDateTime));
        jsonWriter.writeArrayField("replyTo", this.replyTo, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("sender", (JsonSerializable)this.sender);
        jsonWriter.writeStringField("sentDateTime", this.sentDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.sentDateTime));
        jsonWriter.writeStringField("subject", this.subject);
        jsonWriter.writeArrayField("toRecipients", this.toRecipients, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("uniqueBody", (JsonSerializable)this.uniqueBody);
        jsonWriter.writeStringField("webLink", this.webLink);
        jsonWriter.writeArrayField("attachments", this.attachments, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("multiValueExtendedProperties", this.multiValueExtendedProperties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("singleValueExtendedProperties", this.singleValueExtendedProperties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphMessage fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphMessage)jsonReader.readObject(reader -> {
            MicrosoftGraphMessage deserializedMicrosoftGraphMessage = new MicrosoftGraphMessage();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.withId(reader.getString());
                    continue;
                }
                if ("categories".equals(fieldName)) {
                    List categories = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphMessage.withCategories(categories);
                    continue;
                }
                if ("changeKey".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.withChangeKey(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.withCreatedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.withLastModifiedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("bccRecipients".equals(fieldName)) {
                    List bccRecipients;
                    deserializedMicrosoftGraphMessage.bccRecipients = bccRecipients = reader.readArray(reader1 -> MicrosoftGraphRecipient.fromJson(reader1));
                    continue;
                }
                if ("body".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.body = MicrosoftGraphItemBody.fromJson(reader);
                    continue;
                }
                if ("bodyPreview".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.bodyPreview = reader.getString();
                    continue;
                }
                if ("ccRecipients".equals(fieldName)) {
                    List ccRecipients;
                    deserializedMicrosoftGraphMessage.ccRecipients = ccRecipients = reader.readArray(reader1 -> MicrosoftGraphRecipient.fromJson(reader1));
                    continue;
                }
                if ("conversationId".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.conversationId = reader.getString();
                    continue;
                }
                if ("conversationIndex".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.conversationIndex = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("flag".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.flag = MicrosoftGraphFollowupFlag.fromJson(reader);
                    continue;
                }
                if ("from".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.from = MicrosoftGraphRecipient.fromJson(reader);
                    continue;
                }
                if ("hasAttachments".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.hasAttachments = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("importance".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.importance = MicrosoftGraphImportance.fromString(reader.getString());
                    continue;
                }
                if ("inferenceClassification".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.inferenceClassification = MicrosoftGraphInferenceClassificationType.fromString(reader.getString());
                    continue;
                }
                if ("internetMessageHeaders".equals(fieldName)) {
                    List internetMessageHeaders;
                    deserializedMicrosoftGraphMessage.internetMessageHeaders = internetMessageHeaders = reader.readArray(reader1 -> MicrosoftGraphInternetMessageHeader.fromJson(reader1));
                    continue;
                }
                if ("internetMessageId".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.internetMessageId = reader.getString();
                    continue;
                }
                if ("isDeliveryReceiptRequested".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.isDeliveryReceiptRequested = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isDraft".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.isDraft = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isRead".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.isRead = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isReadReceiptRequested".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.isReadReceiptRequested = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("parentFolderId".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.parentFolderId = reader.getString();
                    continue;
                }
                if ("receivedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.receivedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("replyTo".equals(fieldName)) {
                    List replyTo;
                    deserializedMicrosoftGraphMessage.replyTo = replyTo = reader.readArray(reader1 -> MicrosoftGraphRecipient.fromJson(reader1));
                    continue;
                }
                if ("sender".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.sender = MicrosoftGraphRecipient.fromJson(reader);
                    continue;
                }
                if ("sentDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.sentDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("subject".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.subject = reader.getString();
                    continue;
                }
                if ("toRecipients".equals(fieldName)) {
                    List toRecipients;
                    deserializedMicrosoftGraphMessage.toRecipients = toRecipients = reader.readArray(reader1 -> MicrosoftGraphRecipient.fromJson(reader1));
                    continue;
                }
                if ("uniqueBody".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.uniqueBody = MicrosoftGraphItemBody.fromJson(reader);
                    continue;
                }
                if ("webLink".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.webLink = reader.getString();
                    continue;
                }
                if ("attachments".equals(fieldName)) {
                    List attachments;
                    deserializedMicrosoftGraphMessage.attachments = attachments = reader.readArray(reader1 -> MicrosoftGraphAttachment.fromJson(reader1));
                    continue;
                }
                if ("extensions".equals(fieldName)) {
                    List extensions;
                    deserializedMicrosoftGraphMessage.extensions = extensions = reader.readArray(reader1 -> MicrosoftGraphExtension.fromJson(reader1));
                    continue;
                }
                if ("multiValueExtendedProperties".equals(fieldName)) {
                    List multiValueExtendedProperties;
                    deserializedMicrosoftGraphMessage.multiValueExtendedProperties = multiValueExtendedProperties = reader.readArray(reader1 -> MicrosoftGraphMultiValueLegacyExtendedProperty.fromJson(reader1));
                    continue;
                }
                if ("singleValueExtendedProperties".equals(fieldName)) {
                    List singleValueExtendedProperties;
                    deserializedMicrosoftGraphMessage.singleValueExtendedProperties = singleValueExtendedProperties = reader.readArray(reader1 -> MicrosoftGraphSingleValueLegacyExtendedProperty.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphMessage.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphMessage;
        });
    }
}

