/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphManagedAppFlaggedReason;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphManagedAppOperation;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphManagedAppPolicy;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphManagedAppRegistration
extends MicrosoftGraphEntity {
    private Map<String, Object> appIdentifier;
    private String applicationVersion;
    private OffsetDateTime createdDateTime;
    private String deviceName;
    private String deviceTag;
    private String deviceType;
    private List<MicrosoftGraphManagedAppFlaggedReason> flaggedReasons;
    private OffsetDateTime lastSyncDateTime;
    private String managementSdkVersion;
    private String platformVersion;
    private String userId;
    private String version;
    private List<MicrosoftGraphManagedAppPolicy> appliedPolicies;
    private List<MicrosoftGraphManagedAppPolicy> intendedPolicies;
    private List<MicrosoftGraphManagedAppOperation> operations;
    private Map<String, Object> additionalProperties;

    public Map<String, Object> appIdentifier() {
        return this.appIdentifier;
    }

    public MicrosoftGraphManagedAppRegistration withAppIdentifier(Map<String, Object> appIdentifier) {
        this.appIdentifier = appIdentifier;
        return this;
    }

    public String applicationVersion() {
        return this.applicationVersion;
    }

    public MicrosoftGraphManagedAppRegistration withApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
        return this;
    }

    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    public MicrosoftGraphManagedAppRegistration withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public MicrosoftGraphManagedAppRegistration withDeviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    public String deviceTag() {
        return this.deviceTag;
    }

    public MicrosoftGraphManagedAppRegistration withDeviceTag(String deviceTag) {
        this.deviceTag = deviceTag;
        return this;
    }

    public String deviceType() {
        return this.deviceType;
    }

    public MicrosoftGraphManagedAppRegistration withDeviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public List<MicrosoftGraphManagedAppFlaggedReason> flaggedReasons() {
        return this.flaggedReasons;
    }

    public MicrosoftGraphManagedAppRegistration withFlaggedReasons(List<MicrosoftGraphManagedAppFlaggedReason> flaggedReasons) {
        this.flaggedReasons = flaggedReasons;
        return this;
    }

    public OffsetDateTime lastSyncDateTime() {
        return this.lastSyncDateTime;
    }

    public MicrosoftGraphManagedAppRegistration withLastSyncDateTime(OffsetDateTime lastSyncDateTime) {
        this.lastSyncDateTime = lastSyncDateTime;
        return this;
    }

    public String managementSdkVersion() {
        return this.managementSdkVersion;
    }

    public MicrosoftGraphManagedAppRegistration withManagementSdkVersion(String managementSdkVersion) {
        this.managementSdkVersion = managementSdkVersion;
        return this;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public MicrosoftGraphManagedAppRegistration withPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
        return this;
    }

    public String userId() {
        return this.userId;
    }

    public MicrosoftGraphManagedAppRegistration withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String version() {
        return this.version;
    }

    public MicrosoftGraphManagedAppRegistration withVersion(String version) {
        this.version = version;
        return this;
    }

    public List<MicrosoftGraphManagedAppPolicy> appliedPolicies() {
        return this.appliedPolicies;
    }

    public MicrosoftGraphManagedAppRegistration withAppliedPolicies(List<MicrosoftGraphManagedAppPolicy> appliedPolicies) {
        this.appliedPolicies = appliedPolicies;
        return this;
    }

    public List<MicrosoftGraphManagedAppPolicy> intendedPolicies() {
        return this.intendedPolicies;
    }

    public MicrosoftGraphManagedAppRegistration withIntendedPolicies(List<MicrosoftGraphManagedAppPolicy> intendedPolicies) {
        this.intendedPolicies = intendedPolicies;
        return this;
    }

    public List<MicrosoftGraphManagedAppOperation> operations() {
        return this.operations;
    }

    public MicrosoftGraphManagedAppRegistration withOperations(List<MicrosoftGraphManagedAppOperation> operations) {
        this.operations = operations;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphManagedAppRegistration withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphManagedAppRegistration withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.appliedPolicies() != null) {
            this.appliedPolicies().forEach(e -> e.validate());
        }
        if (this.intendedPolicies() != null) {
            this.intendedPolicies().forEach(e -> e.validate());
        }
        if (this.operations() != null) {
            this.operations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeMapField("appIdentifier", this.appIdentifier, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("applicationVersion", this.applicationVersion);
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("deviceName", this.deviceName);
        jsonWriter.writeStringField("deviceTag", this.deviceTag);
        jsonWriter.writeStringField("deviceType", this.deviceType);
        jsonWriter.writeArrayField("flaggedReasons", this.flaggedReasons, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("lastSyncDateTime", this.lastSyncDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastSyncDateTime));
        jsonWriter.writeStringField("managementSdkVersion", this.managementSdkVersion);
        jsonWriter.writeStringField("platformVersion", this.platformVersion);
        jsonWriter.writeStringField("userId", this.userId);
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeArrayField("appliedPolicies", this.appliedPolicies, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("intendedPolicies", this.intendedPolicies, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("operations", this.operations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphManagedAppRegistration fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphManagedAppRegistration)jsonReader.readObject(reader -> {
            MicrosoftGraphManagedAppRegistration deserializedMicrosoftGraphManagedAppRegistration = new MicrosoftGraphManagedAppRegistration();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppRegistration.withId(reader.getString());
                    continue;
                }
                if ("appIdentifier".equals(fieldName)) {
                    Map appIdentifier;
                    deserializedMicrosoftGraphManagedAppRegistration.appIdentifier = appIdentifier = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("applicationVersion".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppRegistration.applicationVersion = reader.getString();
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppRegistration.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("deviceName".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppRegistration.deviceName = reader.getString();
                    continue;
                }
                if ("deviceTag".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppRegistration.deviceTag = reader.getString();
                    continue;
                }
                if ("deviceType".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppRegistration.deviceType = reader.getString();
                    continue;
                }
                if ("flaggedReasons".equals(fieldName)) {
                    List flaggedReasons;
                    deserializedMicrosoftGraphManagedAppRegistration.flaggedReasons = flaggedReasons = reader.readArray(reader1 -> MicrosoftGraphManagedAppFlaggedReason.fromString(reader1.getString()));
                    continue;
                }
                if ("lastSyncDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppRegistration.lastSyncDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("managementSdkVersion".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppRegistration.managementSdkVersion = reader.getString();
                    continue;
                }
                if ("platformVersion".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppRegistration.platformVersion = reader.getString();
                    continue;
                }
                if ("userId".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppRegistration.userId = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppRegistration.version = reader.getString();
                    continue;
                }
                if ("appliedPolicies".equals(fieldName)) {
                    List appliedPolicies;
                    deserializedMicrosoftGraphManagedAppRegistration.appliedPolicies = appliedPolicies = reader.readArray(reader1 -> MicrosoftGraphManagedAppPolicy.fromJson(reader1));
                    continue;
                }
                if ("intendedPolicies".equals(fieldName)) {
                    List intendedPolicies;
                    deserializedMicrosoftGraphManagedAppRegistration.intendedPolicies = intendedPolicies = reader.readArray(reader1 -> MicrosoftGraphManagedAppPolicy.fromJson(reader1));
                    continue;
                }
                if ("operations".equals(fieldName)) {
                    List operations;
                    deserializedMicrosoftGraphManagedAppRegistration.operations = operations = reader.readArray(reader1 -> MicrosoftGraphManagedAppOperation.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphManagedAppRegistration.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphManagedAppRegistration;
        });
    }
}

