/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphStatus;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphUserActivity;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphActivityHistoryItem
extends MicrosoftGraphEntity {
    private Integer activeDurationSeconds;
    private OffsetDateTime createdDateTime;
    private OffsetDateTime expirationDateTime;
    private OffsetDateTime lastActiveDateTime;
    private OffsetDateTime lastModifiedDateTime;
    private OffsetDateTime startedDateTime;
    private MicrosoftGraphStatus status;
    private String userTimezone;
    private MicrosoftGraphUserActivity activity;
    private Map<String, Object> additionalProperties;

    public Integer activeDurationSeconds() {
        return this.activeDurationSeconds;
    }

    public MicrosoftGraphActivityHistoryItem withActiveDurationSeconds(Integer activeDurationSeconds) {
        this.activeDurationSeconds = activeDurationSeconds;
        return this;
    }

    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    public MicrosoftGraphActivityHistoryItem withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    public OffsetDateTime expirationDateTime() {
        return this.expirationDateTime;
    }

    public MicrosoftGraphActivityHistoryItem withExpirationDateTime(OffsetDateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    public OffsetDateTime lastActiveDateTime() {
        return this.lastActiveDateTime;
    }

    public MicrosoftGraphActivityHistoryItem withLastActiveDateTime(OffsetDateTime lastActiveDateTime) {
        this.lastActiveDateTime = lastActiveDateTime;
        return this;
    }

    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public MicrosoftGraphActivityHistoryItem withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    public OffsetDateTime startedDateTime() {
        return this.startedDateTime;
    }

    public MicrosoftGraphActivityHistoryItem withStartedDateTime(OffsetDateTime startedDateTime) {
        this.startedDateTime = startedDateTime;
        return this;
    }

    public MicrosoftGraphStatus status() {
        return this.status;
    }

    public MicrosoftGraphActivityHistoryItem withStatus(MicrosoftGraphStatus status) {
        this.status = status;
        return this;
    }

    public String userTimezone() {
        return this.userTimezone;
    }

    public MicrosoftGraphActivityHistoryItem withUserTimezone(String userTimezone) {
        this.userTimezone = userTimezone;
        return this;
    }

    public MicrosoftGraphUserActivity activity() {
        return this.activity;
    }

    public MicrosoftGraphActivityHistoryItem withActivity(MicrosoftGraphUserActivity activity) {
        this.activity = activity;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphActivityHistoryItem withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphActivityHistoryItem withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.activity() != null) {
            this.activity().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeNumberField("activeDurationSeconds", (Number)this.activeDurationSeconds);
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("expirationDateTime", this.expirationDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDateTime));
        jsonWriter.writeStringField("lastActiveDateTime", this.lastActiveDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastActiveDateTime));
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        jsonWriter.writeStringField("startedDateTime", this.startedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startedDateTime));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("userTimezone", this.userTimezone);
        jsonWriter.writeJsonField("activity", (JsonSerializable)this.activity);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphActivityHistoryItem fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphActivityHistoryItem)jsonReader.readObject(reader -> {
            MicrosoftGraphActivityHistoryItem deserializedMicrosoftGraphActivityHistoryItem = new MicrosoftGraphActivityHistoryItem();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphActivityHistoryItem.withId(reader.getString());
                    continue;
                }
                if ("activeDurationSeconds".equals(fieldName)) {
                    deserializedMicrosoftGraphActivityHistoryItem.activeDurationSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphActivityHistoryItem.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("expirationDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphActivityHistoryItem.expirationDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastActiveDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphActivityHistoryItem.lastActiveDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphActivityHistoryItem.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("startedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphActivityHistoryItem.startedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMicrosoftGraphActivityHistoryItem.status = MicrosoftGraphStatus.fromString(reader.getString());
                    continue;
                }
                if ("userTimezone".equals(fieldName)) {
                    deserializedMicrosoftGraphActivityHistoryItem.userTimezone = reader.getString();
                    continue;
                }
                if ("activity".equals(fieldName)) {
                    deserializedMicrosoftGraphActivityHistoryItem.activity = MicrosoftGraphUserActivity.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphActivityHistoryItem.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphActivityHistoryItem;
        });
    }
}

