// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Expanded info of resource scope, role definition and policy. */
@Fluent
public final class PolicyAssignmentProperties {
    /*
     * Details of the resource scope
     */
    @JsonProperty(value = "scope")
    private PolicyAssignmentPropertiesScope scope;

    /*
     * Details of role definition
     */
    @JsonProperty(value = "roleDefinition")
    private PolicyAssignmentPropertiesRoleDefinition roleDefinition;

    /*
     * Details of the policy
     */
    @JsonProperty(value = "policy")
    private PolicyAssignmentPropertiesPolicy policy;

    /** Creates an instance of PolicyAssignmentProperties class. */
    public PolicyAssignmentProperties() {
    }

    /**
     * Get the scope property: Details of the resource scope.
     *
     * @return the scope value.
     */
    public PolicyAssignmentPropertiesScope scope() {
        return this.scope;
    }

    /**
     * Set the scope property: Details of the resource scope.
     *
     * @param scope the scope value to set.
     * @return the PolicyAssignmentProperties object itself.
     */
    public PolicyAssignmentProperties withScope(PolicyAssignmentPropertiesScope scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the roleDefinition property: Details of role definition.
     *
     * @return the roleDefinition value.
     */
    public PolicyAssignmentPropertiesRoleDefinition roleDefinition() {
        return this.roleDefinition;
    }

    /**
     * Set the roleDefinition property: Details of role definition.
     *
     * @param roleDefinition the roleDefinition value to set.
     * @return the PolicyAssignmentProperties object itself.
     */
    public PolicyAssignmentProperties withRoleDefinition(PolicyAssignmentPropertiesRoleDefinition roleDefinition) {
        this.roleDefinition = roleDefinition;
        return this;
    }

    /**
     * Get the policy property: Details of the policy.
     *
     * @return the policy value.
     */
    public PolicyAssignmentPropertiesPolicy policy() {
        return this.policy;
    }

    /**
     * Set the policy property: Details of the policy.
     *
     * @param policy the policy value to set.
     * @return the PolicyAssignmentProperties object itself.
     */
    public PolicyAssignmentProperties withPolicy(PolicyAssignmentPropertiesPolicy policy) {
        this.policy = policy;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (scope() != null) {
            scope().validate();
        }
        if (roleDefinition() != null) {
            roleDefinition().validate();
        }
        if (policy() != null) {
            policy().validate();
        }
    }
}
