// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Details of the principal. */
@Fluent
public final class ExpandedPropertiesPrincipal {
    /*
     * Id of the principal
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * Display name of the principal
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * Email id of the principal
     */
    @JsonProperty(value = "email")
    private String email;

    /*
     * Type of the principal
     */
    @JsonProperty(value = "type")
    private String type;

    /** Creates an instance of ExpandedPropertiesPrincipal class. */
    public ExpandedPropertiesPrincipal() {
    }

    /**
     * Get the id property: Id of the principal.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Id of the principal.
     *
     * @param id the id value to set.
     * @return the ExpandedPropertiesPrincipal object itself.
     */
    public ExpandedPropertiesPrincipal withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the displayName property: Display name of the principal.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Display name of the principal.
     *
     * @param displayName the displayName value to set.
     * @return the ExpandedPropertiesPrincipal object itself.
     */
    public ExpandedPropertiesPrincipal withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the email property: Email id of the principal.
     *
     * @return the email value.
     */
    public String email() {
        return this.email;
    }

    /**
     * Set the email property: Email id of the principal.
     *
     * @param email the email value to set.
     * @return the ExpandedPropertiesPrincipal object itself.
     */
    public ExpandedPropertiesPrincipal withEmail(String email) {
        this.email = email;
        return this;
    }

    /**
     * Get the type property: Type of the principal.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Type of the principal.
     *
     * @param type the type value to set.
     * @return the ExpandedPropertiesPrincipal object itself.
     */
    public ExpandedPropertiesPrincipal withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
