// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** workbookSortField. */
@Fluent
public final class MicrosoftGraphWorkbookSortField {
    /*
     * Represents whether the sorting is done in an ascending fashion.
     */
    @JsonProperty(value = "ascending")
    private Boolean ascending;

    /*
     * Represents the color that is the target of the condition if the sorting is on font or cell color.
     */
    @JsonProperty(value = "color")
    private String color;

    /*
     * Represents additional sorting options for this field. The possible values are: Normal, TextAsNumber.
     */
    @JsonProperty(value = "dataOption")
    private String dataOption;

    /*
     * workbookIcon
     */
    @JsonProperty(value = "icon")
    private MicrosoftGraphWorkbookIcon icon;

    /*
     * Represents the column (or row, depending on the sort orientation) that the condition is on. Represented as an
     * offset from the first column (or row).
     */
    @JsonProperty(value = "key")
    private Integer key;

    /*
     * Represents the type of sorting of this condition. The possible values are: Value, CellColor, FontColor, Icon.
     */
    @JsonProperty(value = "sortOn")
    private String sortOn;

    /*
     * workbookSortField
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphWorkbookSortField class. */
    public MicrosoftGraphWorkbookSortField() {
    }

    /**
     * Get the ascending property: Represents whether the sorting is done in an ascending fashion.
     *
     * @return the ascending value.
     */
    public Boolean ascending() {
        return this.ascending;
    }

    /**
     * Set the ascending property: Represents whether the sorting is done in an ascending fashion.
     *
     * @param ascending the ascending value to set.
     * @return the MicrosoftGraphWorkbookSortField object itself.
     */
    public MicrosoftGraphWorkbookSortField withAscending(Boolean ascending) {
        this.ascending = ascending;
        return this;
    }

    /**
     * Get the color property: Represents the color that is the target of the condition if the sorting is on font or
     * cell color.
     *
     * @return the color value.
     */
    public String color() {
        return this.color;
    }

    /**
     * Set the color property: Represents the color that is the target of the condition if the sorting is on font or
     * cell color.
     *
     * @param color the color value to set.
     * @return the MicrosoftGraphWorkbookSortField object itself.
     */
    public MicrosoftGraphWorkbookSortField withColor(String color) {
        this.color = color;
        return this;
    }

    /**
     * Get the dataOption property: Represents additional sorting options for this field. The possible values are:
     * Normal, TextAsNumber.
     *
     * @return the dataOption value.
     */
    public String dataOption() {
        return this.dataOption;
    }

    /**
     * Set the dataOption property: Represents additional sorting options for this field. The possible values are:
     * Normal, TextAsNumber.
     *
     * @param dataOption the dataOption value to set.
     * @return the MicrosoftGraphWorkbookSortField object itself.
     */
    public MicrosoftGraphWorkbookSortField withDataOption(String dataOption) {
        this.dataOption = dataOption;
        return this;
    }

    /**
     * Get the icon property: workbookIcon.
     *
     * @return the icon value.
     */
    public MicrosoftGraphWorkbookIcon icon() {
        return this.icon;
    }

    /**
     * Set the icon property: workbookIcon.
     *
     * @param icon the icon value to set.
     * @return the MicrosoftGraphWorkbookSortField object itself.
     */
    public MicrosoftGraphWorkbookSortField withIcon(MicrosoftGraphWorkbookIcon icon) {
        this.icon = icon;
        return this;
    }

    /**
     * Get the key property: Represents the column (or row, depending on the sort orientation) that the condition is on.
     * Represented as an offset from the first column (or row).
     *
     * @return the key value.
     */
    public Integer key() {
        return this.key;
    }

    /**
     * Set the key property: Represents the column (or row, depending on the sort orientation) that the condition is on.
     * Represented as an offset from the first column (or row).
     *
     * @param key the key value to set.
     * @return the MicrosoftGraphWorkbookSortField object itself.
     */
    public MicrosoftGraphWorkbookSortField withKey(Integer key) {
        this.key = key;
        return this;
    }

    /**
     * Get the sortOn property: Represents the type of sorting of this condition. The possible values are: Value,
     * CellColor, FontColor, Icon.
     *
     * @return the sortOn value.
     */
    public String sortOn() {
        return this.sortOn;
    }

    /**
     * Set the sortOn property: Represents the type of sorting of this condition. The possible values are: Value,
     * CellColor, FontColor, Icon.
     *
     * @param sortOn the sortOn value to set.
     * @return the MicrosoftGraphWorkbookSortField object itself.
     */
    public MicrosoftGraphWorkbookSortField withSortOn(String sortOn) {
        this.sortOn = sortOn;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookSortField.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookSortField.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookSortField object itself.
     */
    public MicrosoftGraphWorkbookSortField withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (icon() != null) {
            icon().validate();
        }
    }
}
