// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** geoCoordinates. */
@Fluent
public final class MicrosoftGraphGeoCoordinates {
    /*
     * Optional. The altitude (height), in feet,  above sea level for the item. Read-only.
     */
    @JsonProperty(value = "altitude")
    private Double altitude;

    /*
     * Optional. The latitude, in decimal, for the item. Read-only.
     */
    @JsonProperty(value = "latitude")
    private Double latitude;

    /*
     * Optional. The longitude, in decimal, for the item. Read-only.
     */
    @JsonProperty(value = "longitude")
    private Double longitude;

    /*
     * geoCoordinates
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphGeoCoordinates class. */
    public MicrosoftGraphGeoCoordinates() {
    }

    /**
     * Get the altitude property: Optional. The altitude (height), in feet, above sea level for the item. Read-only.
     *
     * @return the altitude value.
     */
    public Double altitude() {
        return this.altitude;
    }

    /**
     * Set the altitude property: Optional. The altitude (height), in feet, above sea level for the item. Read-only.
     *
     * @param altitude the altitude value to set.
     * @return the MicrosoftGraphGeoCoordinates object itself.
     */
    public MicrosoftGraphGeoCoordinates withAltitude(Double altitude) {
        this.altitude = altitude;
        return this;
    }

    /**
     * Get the latitude property: Optional. The latitude, in decimal, for the item. Read-only.
     *
     * @return the latitude value.
     */
    public Double latitude() {
        return this.latitude;
    }

    /**
     * Set the latitude property: Optional. The latitude, in decimal, for the item. Read-only.
     *
     * @param latitude the latitude value to set.
     * @return the MicrosoftGraphGeoCoordinates object itself.
     */
    public MicrosoftGraphGeoCoordinates withLatitude(Double latitude) {
        this.latitude = latitude;
        return this;
    }

    /**
     * Get the longitude property: Optional. The longitude, in decimal, for the item. Read-only.
     *
     * @return the longitude value.
     */
    public Double longitude() {
        return this.longitude;
    }

    /**
     * Set the longitude property: Optional. The longitude, in decimal, for the item. Read-only.
     *
     * @param longitude the longitude value to set.
     * @return the MicrosoftGraphGeoCoordinates object itself.
     */
    public MicrosoftGraphGeoCoordinates withLongitude(Double longitude) {
        this.longitude = longitude;
        return this;
    }

    /**
     * Get the additionalProperties property: geoCoordinates.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: geoCoordinates.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphGeoCoordinates object itself.
     */
    public MicrosoftGraphGeoCoordinates withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
