// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** folder. */
@Fluent
public final class MicrosoftGraphFolder {
    /*
     * Number of children contained immediately within this container.
     */
    @JsonProperty(value = "childCount")
    private Integer childCount;

    /*
     * folderView
     */
    @JsonProperty(value = "view")
    private MicrosoftGraphFolderView view;

    /*
     * folder
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphFolder class. */
    public MicrosoftGraphFolder() {
    }

    /**
     * Get the childCount property: Number of children contained immediately within this container.
     *
     * @return the childCount value.
     */
    public Integer childCount() {
        return this.childCount;
    }

    /**
     * Set the childCount property: Number of children contained immediately within this container.
     *
     * @param childCount the childCount value to set.
     * @return the MicrosoftGraphFolder object itself.
     */
    public MicrosoftGraphFolder withChildCount(Integer childCount) {
        this.childCount = childCount;
        return this;
    }

    /**
     * Get the view property: folderView.
     *
     * @return the view value.
     */
    public MicrosoftGraphFolderView view() {
        return this.view;
    }

    /**
     * Set the view property: folderView.
     *
     * @param view the view value to set.
     * @return the MicrosoftGraphFolder object itself.
     */
    public MicrosoftGraphFolder withView(MicrosoftGraphFolderView view) {
        this.view = view;
        return this;
    }

    /**
     * Get the additionalProperties property: folder.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: folder.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphFolder object itself.
     */
    public MicrosoftGraphFolder withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (view() != null) {
            view().validate();
        }
    }
}
