// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** attachment. */
@Fluent
public final class MicrosoftGraphAttachment extends MicrosoftGraphEntity {
    /*
     * The MIME type.
     */
    @JsonProperty(value = "contentType")
    private String contentType;

    /*
     * true if the attachment is an inline attachment; otherwise, false.
     */
    @JsonProperty(value = "isInline")
    private Boolean isInline;

    /*
     * The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For
     * example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'
     */
    @JsonProperty(value = "lastModifiedDateTime")
    private OffsetDateTime lastModifiedDateTime;

    /*
     * The attachment's file name.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The length of the attachment in bytes.
     */
    @JsonProperty(value = "size")
    private Integer size;

    /*
     * attachment
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphAttachment class. */
    public MicrosoftGraphAttachment() {
    }

    /**
     * Get the contentType property: The MIME type.
     *
     * @return the contentType value.
     */
    public String contentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: The MIME type.
     *
     * @param contentType the contentType value to set.
     * @return the MicrosoftGraphAttachment object itself.
     */
    public MicrosoftGraphAttachment withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the isInline property: true if the attachment is an inline attachment; otherwise, false.
     *
     * @return the isInline value.
     */
    public Boolean isInline() {
        return this.isInline;
    }

    /**
     * Set the isInline property: true if the attachment is an inline attachment; otherwise, false.
     *
     * @param isInline the isInline value to set.
     * @return the MicrosoftGraphAttachment object itself.
     */
    public MicrosoftGraphAttachment withIsInline(Boolean isInline) {
        this.isInline = isInline;
        return this;
    }

    /**
     * Get the lastModifiedDateTime property: The Timestamp type represents date and time information using ISO 8601
     * format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     *
     * @return the lastModifiedDateTime value.
     */
    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    /**
     * Set the lastModifiedDateTime property: The Timestamp type represents date and time information using ISO 8601
     * format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     *
     * @param lastModifiedDateTime the lastModifiedDateTime value to set.
     * @return the MicrosoftGraphAttachment object itself.
     */
    public MicrosoftGraphAttachment withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    /**
     * Get the name property: The attachment's file name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The attachment's file name.
     *
     * @param name the name value to set.
     * @return the MicrosoftGraphAttachment object itself.
     */
    public MicrosoftGraphAttachment withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the size property: The length of the attachment in bytes.
     *
     * @return the size value.
     */
    public Integer size() {
        return this.size;
    }

    /**
     * Set the size property: The length of the attachment in bytes.
     *
     * @param size the size value to set.
     * @return the MicrosoftGraphAttachment object itself.
     */
    public MicrosoftGraphAttachment withSize(Integer size) {
        this.size = size;
        return this;
    }

    /**
     * Get the additionalProperties property: attachment.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: attachment.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphAttachment object itself.
     */
    public MicrosoftGraphAttachment withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphAttachment withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
