// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.RoleManagementPolicyAssignmentInner;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in RoleManagementPolicyAssignmentsClient. */
public interface RoleManagementPolicyAssignmentsClient extends InnerSupportsDelete<Void> {
    /**
     * Get the specified role management policy assignment for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role management policy assignment for a resource scope along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RoleManagementPolicyAssignmentInner>> getWithResponseAsync(
        String scope, String roleManagementPolicyAssignmentName);

    /**
     * Get the specified role management policy assignment for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role management policy assignment for a resource scope on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RoleManagementPolicyAssignmentInner> getAsync(String scope, String roleManagementPolicyAssignmentName);

    /**
     * Get the specified role management policy assignment for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role management policy assignment for a resource scope along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RoleManagementPolicyAssignmentInner> getWithResponse(
        String scope, String roleManagementPolicyAssignmentName, Context context);

    /**
     * Get the specified role management policy assignment for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role management policy assignment for a resource scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RoleManagementPolicyAssignmentInner get(String scope, String roleManagementPolicyAssignmentName);

    /**
     * Create a role management policy assignment.
     *
     * @param scope The scope of the role management policy assignment to upsert.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     upsert.
     * @param parameters Parameters for the role management policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RoleManagementPolicyAssignmentInner>> createWithResponseAsync(
        String scope, String roleManagementPolicyAssignmentName, RoleManagementPolicyAssignmentInner parameters);

    /**
     * Create a role management policy assignment.
     *
     * @param scope The scope of the role management policy assignment to upsert.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     upsert.
     * @param parameters Parameters for the role management policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RoleManagementPolicyAssignmentInner> createAsync(
        String scope, String roleManagementPolicyAssignmentName, RoleManagementPolicyAssignmentInner parameters);

    /**
     * Create a role management policy assignment.
     *
     * @param scope The scope of the role management policy assignment to upsert.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     upsert.
     * @param parameters Parameters for the role management policy assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RoleManagementPolicyAssignmentInner> createWithResponse(
        String scope,
        String roleManagementPolicyAssignmentName,
        RoleManagementPolicyAssignmentInner parameters,
        Context context);

    /**
     * Create a role management policy assignment.
     *
     * @param scope The scope of the role management policy assignment to upsert.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     upsert.
     * @param parameters Parameters for the role management policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RoleManagementPolicyAssignmentInner create(
        String scope, String roleManagementPolicyAssignmentName, RoleManagementPolicyAssignmentInner parameters);

    /**
     * Delete a role management policy assignment.
     *
     * @param scope The scope of the role management policy assignment to delete.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String scope, String roleManagementPolicyAssignmentName);

    /**
     * Delete a role management policy assignment.
     *
     * @param scope The scope of the role management policy assignment to delete.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String scope, String roleManagementPolicyAssignmentName);

    /**
     * Delete a role management policy assignment.
     *
     * @param scope The scope of the role management policy assignment to delete.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String scope, String roleManagementPolicyAssignmentName, Context context);

    /**
     * Delete a role management policy assignment.
     *
     * @param scope The scope of the role management policy assignment to delete.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String scope, String roleManagementPolicyAssignmentName);

    /**
     * Gets role management assignment policies for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management assignment policies for a resource scope as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RoleManagementPolicyAssignmentInner> listForScopeAsync(String scope);

    /**
     * Gets role management assignment policies for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management assignment policies for a resource scope as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RoleManagementPolicyAssignmentInner> listForScope(String scope);

    /**
     * Gets role management assignment policies for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management assignment policies for a resource scope as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RoleManagementPolicyAssignmentInner> listForScope(String scope, Context context);
}
